/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import tel.schich.javacan.NativeInterface;

@Nullable
public class OSError {
    public final int errorNumber;
    public final String errorMessage;

    public OSError(int errorNumber, @NonNull String errorMessage) {
        this.errorNumber = errorNumber;
        this.errorMessage = errorMessage;
    }

    public String toString() {
        return "OSError{errorNumber=" + this.errorNumber + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }

    public static @Nullable OSError getLast() {
        int lastErrno = NativeInterface.errno();
        if (lastErrno == 0) {
            return null;
        }
        return new OSError(lastErrno, NativeInterface.errstr(lastErrno));
    }

    public boolean mayTryAgain() {
        switch (this.errorNumber) {
            case 11: {
                return true;
            }
        }
        return false;
    }
}

