/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import tel.schich.javacan.CanFrame;

class NativeInterface {
    private static boolean initialized = false;

    NativeInterface() {
    }

    public static native long resolveInterfaceName(@NonNull String var0);

    public static native int createSocket();

    public static native int bindSocket(int var0, long var1);

    public static native int close(int var0);

    public static native int errno();

    public static native @NonNull String errstr(int var0);

    public static native int setBlockingMode(int var0, boolean var1);

    public static native int getBlockingMode(int var0);

    public static native int setTimeouts(int var0, long var1, long var3);

    public static native @Nullable CanFrame read(int var0);

    public static native int write(int var0, @NonNull CanFrame var1);

    public static native int setFilter(int var0, int[] var1, int[] var2);

    public static native int setLoopback(int var0, boolean var1);

    public static native int getLoopback(int var0);

    public static native int setReceiveOwnMessages(int var0, boolean var1);

    public static native int getReceiveOwnMessages(int var0);

    public static native int setJoinFilters(int var0, boolean var1);

    public static native int getJoinFilters(int var0);

    public static native int setAllowFDFrames(int var0, boolean var1);

    public static native int getAllowFDFrames(int var0);

    public static native int setErrorFilter(int var0, int var1);

    public static native int getErrorFilter(int var0);

    public static synchronized void initialize() {
        if (!initialized) {
            String libName = "JavaCAN";
            String arch = System.getProperty("os.arch").toLowerCase();
            String archSuffix = arch.contains("arm") ? "armv7" : (arch.contains("86") || arch.contains("amd") ? (arch.contains("64") ? "x86_64" : "x86_32") : (arch.contains("aarch64") ? "aarch64" : arch));
            String sourceLibPath = "/native/lib" + libName + "-" + archSuffix + ".so";
            try (InputStream libStream = NativeInterface.class.getResourceAsStream(sourceLibPath);){
                if (libStream == null) {
                    throw new LinkageError("Failed to load the native library: " + sourceLibPath + " not found.");
                }
                Path tempDirectory = Files.createTempDirectory(libName, new FileAttribute[0]);
                Path libPath = tempDirectory.resolve("lib" + libName + ".so");
                Files.copy(libStream, libPath, StandardCopyOption.REPLACE_EXISTING);
                System.load(libPath.toString());
                libPath.toFile().deleteOnExit();
            }
            catch (IOException e) {
                throw new LinkageError("Unable to load native library!", e);
            }
            initialized = true;
        }
    }

    static class Errno {
        public static final int EIO = 5;
        public static final int EAGAIN = 11;

        Errno() {
        }
    }
}

