/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.io.IOException;
import org.checkerframework.checker.nullness.qual.NonNull;
import tel.schich.javacan.CanFilter;
import tel.schich.javacan.CanFrame;
import tel.schich.javacan.HasFileDescriptor;
import tel.schich.javacan.NativeException;
import tel.schich.javacan.NativeInterface;
import tel.schich.javacan.OSError;

public class CanSocket
extends HasFileDescriptor {
    private final int sockFD;

    private CanSocket(int sock) {
        this.sockFD = sock;
    }

    public void bind(@NonNull String interfaceName) throws NativeException {
        long ifindex = NativeInterface.resolveInterfaceName(interfaceName);
        if (ifindex == 0L) {
            throw new NativeException("Unknown interface: " + interfaceName);
        }
        int result = NativeInterface.bindSocket(this.sockFD, ifindex);
        if (result == -1) {
            throw new NativeException("Unable to bind!");
        }
    }

    public void setBlockingMode(boolean block) throws NativeException {
        if (NativeInterface.setBlockingMode(this.sockFD, block) == -1) {
            throw new NativeException("Unable to set the blocking mode!");
        }
    }

    public boolean isBlocking() throws NativeException {
        int result = NativeInterface.getBlockingMode(this.sockFD);
        if (result == -1) {
            throw new NativeException("Unable to get blocking mode!");
        }
        return result == 1;
    }

    public void setTimeouts(long read, long write) throws NativeException {
        if (NativeInterface.setTimeouts(this.sockFD, read, write) == -1) {
            throw new NativeException("Unable to set timeouts!");
        }
    }

    public void setLoopback(boolean loopback) throws NativeException {
        int result = NativeInterface.setLoopback(this.sockFD, loopback);
        if (result == -1) {
            throw new NativeException("Unable to set loopback state!");
        }
    }

    public boolean isLoopback() throws NativeException {
        int result = NativeInterface.getLoopback(this.sockFD);
        if (result == -1) {
            throw new NativeException("Unable to get loopback state!");
        }
        return result != 0;
    }

    public void setReceiveOwnMessages(boolean receiveOwnMessages) throws NativeException {
        int result = NativeInterface.setReceiveOwnMessages(this.sockFD, receiveOwnMessages);
        if (result == -1) {
            throw new NativeException("Unable to set receive own messages state!");
        }
    }

    public boolean isReceivingOwnMessages() throws NativeException {
        int result = NativeInterface.getReceiveOwnMessages(this.sockFD);
        if (result == -1) {
            throw new NativeException("Unable to get receive own messages state!");
        }
        return result != 0;
    }

    public void setAllowFDFrames(boolean allowFDFrames) throws NativeException {
        int result = NativeInterface.setAllowFDFrames(this.sockFD, allowFDFrames);
        if (result == -1) {
            throw new NativeException("Unable to set FD frame support!");
        }
    }

    public boolean isAllowFDFrames() throws NativeException {
        int result = NativeInterface.getAllowFDFrames(this.sockFD);
        if (result == -1) {
            throw new NativeException("Unable to get FD frame support!");
        }
        return result != 0;
    }

    public void setJoinFilters(boolean joinFilters) throws NativeException {
        int result = NativeInterface.setJoinFilters(this.sockFD, joinFilters);
        if (result == -1) {
            throw new NativeException("Unable to set the filter joining mode!");
        }
    }

    public boolean isJoiningFilters() throws NativeException {
        int result = NativeInterface.getJoinFilters(this.sockFD);
        if (result == -1) {
            throw new NativeException("Unable to get the filter joining mode!");
        }
        return result != 0;
    }

    public void setErrorFilter(int mask) throws NativeException {
        int result = NativeInterface.setErrorFilter(this.sockFD, mask);
        if (result == -1) {
            throw new NativeException("Unable to set the error filter!");
        }
    }

    public int getErrorFilter() throws NativeException {
        int mask = NativeInterface.getErrorFilter(this.sockFD);
        if (mask == -1) {
            throw new NativeException("Unable to get the error filter!");
        }
        return mask;
    }

    public void setFilters(CanFilter ... filters) {
        int[] ids = new int[filters.length];
        int[] masks = new int[filters.length];
        NativeInterface.setFilter(this.sockFD, ids, masks);
    }

    public @NonNull CanFrame read() throws NativeException, IOException {
        CanFrame frame = NativeInterface.read(this.sockFD);
        if (frame == null) {
            throw new NativeException("Unable to read a frame!");
        }
        if (frame.isIncomplete()) {
            throw new IOException("Frame is incomplete!");
        }
        return frame;
    }

    public CanFrame readRetrying() throws NativeException, IOException {
        CanFrame frame;
        while ((frame = NativeInterface.read(this.sockFD)) == null) {
            OSError err = OSError.getLast();
            if (err != null && err.mayTryAgain()) continue;
            throw new NativeException("Unable to read a frame and retry is not possible!", err);
        }
        if (frame.isIncomplete()) {
            throw new IOException("Frame is incomplete, no retrying!");
        }
        return frame;
    }

    public void write(CanFrame frame) throws NativeException, IOException {
        if (frame == null) {
            throw new NullPointerException("The frame may not be null!");
        }
        int writtenBytes = NativeInterface.write(this.sockFD, frame);
        if (writtenBytes == -1) {
            throw new NativeException("Unable to write the frame!");
        }
        if (writtenBytes > 0) {
            throw new IOException("Unable to write the entire frame!");
        }
    }

    public void close() throws NativeException {
        if (NativeInterface.close(this.sockFD) == -1) {
            throw new NativeException("Unable to close the socket!");
        }
    }

    @Override
    int getFileDescriptor() {
        return this.sockFD;
    }

    public static @NonNull CanSocket create() throws NativeException {
        int fd = NativeInterface.createSocket();
        if (fd == -1) {
            throw new NativeException("Unable to create socket!");
        }
        return new CanSocket(fd);
    }
}

