/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.util.Arrays;
import java.util.Objects;

public class CanFrame {
    public static final int EFF_FLAG = Integer.MIN_VALUE;
    public static final int RTR_FLAG = 0x40000000;
    public static final int ERR_FLAG = 0x20000000;
    private static final int SFF_MASK = 2047;
    private static final int EFF_MASK = 0x1FFFFFFF;
    private static final int ERR_MASK = 0x1FFFFFFF;
    public static final byte FD_NO_FLAGS = 0;
    public static final byte FD_FLAG_BRS = 1;
    public static final byte FD_FLAG_ESI = 2;
    public static final int MAX_DATA_LENGTH = 8;
    public static final int MAX_FD_DATA_LENGTH = 64;
    private final int id;
    private final byte flags;
    private final byte[] payload;

    private CanFrame(int id, byte flags, byte[] payload) {
        this.id = id;
        this.flags = 0;
        this.payload = payload;
    }

    public int getId() {
        return this.isExtended() ? this.id & 0x1FFFFFFF : this.id & 0x7FF;
    }

    public byte getFlags() {
        return this.flags;
    }

    public byte[] getPayload() {
        byte[] copy = new byte[this.payload.length];
        System.arraycopy(this.payload, 0, copy, 0, this.payload.length);
        return copy;
    }

    public boolean isFDFrame() {
        return this.flags != 0 || this.payload.length > 8;
    }

    boolean isIncomplete() {
        return this.payload == null;
    }

    public boolean isExtended() {
        return (this.id & Integer.MIN_VALUE) != 0;
    }

    public boolean isError() {
        return (this.id & 0x20000000) != 0;
    }

    public int getError() {
        return this.id & 0x1FFFFFFF;
    }

    public boolean isRemoveTransmissionRequest() {
        return (this.id & 0x40000000) != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Can");
        if (this.isFDFrame()) {
            sb.append("FD");
        }
        sb.append("Frame(").append("ID=").append(String.format("%02X", this.getId())).append(", ").append("FLAGS=").append(String.format("%X", this.getFlags())).append(", ").append("LEN=").append(this.payload.length).append(", DATA=[");
        if (this.payload.length > 0) {
            sb.append(String.format("%02X", this.payload[0]));
            for (int i = 1; i < this.payload.length; ++i) {
                sb.append(", ").append(String.format("%02X", this.payload[i]));
            }
        }
        return sb.append("])").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CanFrame)) {
            return false;
        }
        CanFrame canFrame = (CanFrame)o;
        return this.id == canFrame.id && Arrays.equals(this.payload, canFrame.payload);
    }

    public int hashCode() {
        int result = Objects.hash(this.id);
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    public static CanFrame create(int id, byte[] payload) {
        return CanFrame.create(id, (byte)0, payload);
    }

    public static CanFrame create(int id, byte flags, byte[] payload) {
        if (payload.length > 64) {
            throw new IllegalArgumentException("payload must fit in 64 bytes!");
        }
        return new CanFrame(id, flags, payload);
    }
}

