/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.dataset;

import clojure.lang.IFn;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;

public class ParquetRowWriter
extends WriteSupport<Long> {
    public final IFn rowWriter;
    public final MessageType schema;
    public final Map<String, String> metadata;
    public RecordConsumer consumer;
    public Object dataset;

    public ParquetRowWriter(IFn iFn, MessageType messageType, Map<String, String> map) {
        this.rowWriter = iFn;
        this.schema = messageType;
        this.metadata = map;
        this.consumer = null;
        this.dataset = null;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        return new WriteSupport.WriteContext(this.schema, this.metadata);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.consumer = recordConsumer;
    }

    public void write(Long l) {
        this.rowWriter.invoke(this.dataset, (Object)l, (Object)this.consumer);
    }

    public static class WriterBuilder
    extends ParquetWriter.Builder<Long, WriterBuilder> {
        public final ParquetRowWriter writer;

        public WriterBuilder(OutputFile outputFile, ParquetRowWriter parquetRowWriter) {
            super(outputFile);
            this.writer = parquetRowWriter;
        }

        public WriterBuilder self() {
            return this;
        }

        protected WriteSupport<Long> getWriteSupport(Configuration configuration) {
            return this.writer;
        }
    }
}

