/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.dataset;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class LocalInputFile
implements InputFile {
    private final RandomAccessFile input;

    public LocalInputFile(Path path) throws FileNotFoundException {
        this.input = new RandomAccessFile(path.toFile(), "r");
    }

    public long getLength() throws IOException {
        return this.input.length();
    }

    public SeekableInputStream newStream() throws IOException {
        return new SeekableInputStream(){
            private final byte[] page = new byte[8192];
            private long markPos = 0L;

            public int read() throws IOException {
                return LocalInputFile.this.input.read();
            }

            public int read(byte[] byArray) throws IOException {
                return LocalInputFile.this.input.read(byArray);
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                return LocalInputFile.this.input.read(byArray, n, n2);
            }

            public long skip(long l) throws IOException {
                long l2 = LocalInputFile.this.input.getFilePointer();
                long l3 = LocalInputFile.this.input.length() - l2;
                l = Math.min(l, l3);
                long l4 = l2 + l;
                LocalInputFile.this.input.seek(l4);
                long l5 = LocalInputFile.this.input.getFilePointer();
                return l5 - l2;
            }

            public int available() {
                return 0;
            }

            public void close() throws IOException {
                LocalInputFile.this.input.close();
            }

            private <T extends Throwable, R> R uncheckedExceptionThrow(Throwable throwable) throws T {
                throw throwable;
            }

            public synchronized void mark(int n) {
                try {
                    this.markPos = LocalInputFile.this.input.getFilePointer();
                }
                catch (IOException iOException) {
                    this.uncheckedExceptionThrow(iOException);
                }
            }

            public synchronized void reset() throws IOException {
                LocalInputFile.this.input.seek(this.markPos);
            }

            public boolean markSupported() {
                return true;
            }

            public long getPos() throws IOException {
                return LocalInputFile.this.input.getFilePointer();
            }

            public void seek(long l) throws IOException {
                LocalInputFile.this.input.seek(l);
            }

            public void readFully(byte[] byArray) throws IOException {
                LocalInputFile.this.input.readFully(byArray);
            }

            public void readFully(byte[] byArray, int n, int n2) throws IOException {
                LocalInputFile.this.input.readFully(byArray, n, n2);
            }

            public int read(ByteBuffer byteBuffer) throws IOException {
                return LocalInputFile.this.readDirectBuffer(byteBuffer, this.page, LocalInputFile.this.input::read);
            }

            public void readFully(ByteBuffer byteBuffer) throws IOException {
                LocalInputFile.readFullyDirectBuffer(byteBuffer, this.page, LocalInputFile.this.input::read);
            }
        };
    }

    private int readDirectBuffer(ByteBuffer byteBuffer, byte[] byArray, ByteBufferReader byteBufferReader) throws IOException {
        int n;
        int n2 = Math.min(byteBuffer.remaining(), byArray.length);
        int n3 = 0;
        while ((n = byteBufferReader.read(byArray, 0, n2)) == byArray.length) {
            byteBuffer.put(byArray);
            n3 += n;
            n2 = Math.min(byteBuffer.remaining(), byArray.length);
        }
        if (n < 0) {
            return n3 == 0 ? -1 : n3;
        }
        byteBuffer.put(byArray, 0, n);
        return n3 += n;
    }

    private static void readFullyDirectBuffer(ByteBuffer byteBuffer, byte[] byArray, ByteBufferReader byteBufferReader) throws IOException {
        int n = Math.min(byteBuffer.remaining(), byArray.length);
        int n2 = 0;
        while (n > 0 && (n2 = byteBufferReader.read(byArray, 0, n)) >= 0) {
            byteBuffer.put(byArray, 0, n2);
            n = Math.min(byteBuffer.remaining(), byArray.length);
        }
        if (n2 < 0 && byteBuffer.remaining() > 0) {
            throw new EOFException("Reached the end of stream with " + byteBuffer.remaining() + " bytes left to read");
        }
    }

    private static interface ByteBufferReader {
        public int read(byte[] var1, int var2, int var3) throws IOException;
    }
}

