/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.lib.yasson;

import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import systems.uom.ucum.format.UCUMFormat;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.uom.lib.yasson.SerializationMode;

public class UnitJsonSerializer
implements JsonbSerializer<Unit> {
    private final SerializationMode mode;

    private UnitJsonSerializer(SerializationMode mode) {
        this.mode = mode;
    }

    public UnitJsonSerializer() {
        this(SerializationMode.SIMPLE);
    }

    public static UnitJsonSerializer ofMode(SerializationMode mode) {
        return new UnitJsonSerializer(mode);
    }

    public void serialize(Unit value, JsonGenerator generator, SerializationContext ctx) {
        UnitFormat format = UnitJsonSerializer.getFormat(this.mode);
        if (value == null) {
            generator.writeNull();
        } else {
            String formattedUnit = format.format(value);
            generator.write(formattedUnit);
        }
    }

    private static final UnitFormat getFormat(SerializationMode mode) {
        switch (mode) {
            case UCUM: {
                return UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
            }
            case EBNF: {
                return EBNFUnitFormat.getInstance();
            }
        }
        return SimpleUnitFormat.getInstance();
    }
}

