/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.lib.yasson;

import java.lang.reflect.Type;
import java.text.ParsePosition;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import systems.uom.ucum.format.UCUMFormat;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.uom.lib.yasson.SerializationMode;

public class UnitJsonDeserializer
implements JsonbDeserializer<Unit> {
    private final SerializationMode mode;

    private UnitJsonDeserializer(SerializationMode mode) {
        this.mode = mode;
    }

    public UnitJsonDeserializer() {
        this(SerializationMode.SIMPLE);
    }

    public static UnitJsonDeserializer ofMode(SerializationMode mode) {
        return new UnitJsonDeserializer(mode);
    }

    public Unit deserialize(JsonParser parser, DeserializationContext ctx, Type runtimeType) {
        Unit retValue = AbstractUnit.ONE;
        UnitFormat format = UnitJsonDeserializer.getFormat(this.mode);
        while (parser.hasNext()) {
            JsonParser.Event evt = parser.next();
            switch (evt) {
                case VALUE_STRING: {
                    String str = parser.getString();
                    retValue = format.parse((CharSequence)str, new ParsePosition(0));
                    break;
                }
            }
        }
        return retValue;
    }

    private static final UnitFormat getFormat(SerializationMode mode) {
        switch (mode) {
            case UCUM: {
                return UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE);
            }
            case EBNF: {
                return EBNFUnitFormat.getInstance();
            }
        }
        return SimpleUnitFormat.getInstance();
    }
}

