/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.lib.yasson;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import javax.measure.Dimension;
import tech.units.indriya.unit.UnitDimension;

public class DimensionJsonDeserializer
implements JsonbDeserializer<Dimension> {
    private static Dimension parseBaseDimension(String symbol) {
        switch (symbol) {
            case "[N]": {
                return UnitDimension.AMOUNT_OF_SUBSTANCE;
            }
            case "[I]": {
                return UnitDimension.ELECTRIC_CURRENT;
            }
            case "[L]": {
                return UnitDimension.LENGTH;
            }
            case "[J]": {
                return UnitDimension.LUMINOUS_INTENSITY;
            }
            case "[M]": {
                return UnitDimension.MASS;
            }
            case "[\u0398]": {
                return UnitDimension.TEMPERATURE;
            }
            case "[T]": {
                return UnitDimension.TIME;
            }
        }
        throw new IllegalArgumentException(String.format("dimension symbol '%s' not supported, maybe dimensionless or wrong universe?", symbol));
    }

    public Dimension deserialize(JsonParser parser, DeserializationContext ctx, Type runtimeType) {
        JsonObject obj = parser.getObject();
        Set keys = obj.keySet();
        HashMap<String, Integer> baseDimensionsStrings = new HashMap<String, Integer>();
        for (String key : keys) {
            baseDimensionsStrings.put(key, obj.getInt(key));
        }
        HashMap<Dimension, Integer> baseDimensions = new HashMap<Dimension, Integer>(baseDimensionsStrings.entrySet().stream().collect(Collectors.toMap(entry -> DimensionJsonDeserializer.parseBaseDimension((String)entry.getKey()), entry -> (Integer)entry.getValue())));
        Dimension retValue = UnitDimension.NONE;
        for (Dimension baseDimension : baseDimensions.keySet()) {
            int exp = (Integer)baseDimensions.get(baseDimension);
            retValue = retValue.multiply(baseDimension.pow(exp));
        }
        return retValue;
    }
}

