/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function;

import java.util.Objects;
import java.util.function.Supplier;

public class Lazy<T> {
    private final Supplier<? extends T> supplier;
    private T value;
    private boolean memorized;

    public Lazy(Supplier<? extends T> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMemorized() {
        Lazy lazy = this;
        synchronized (lazy) {
            return this.memorized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Lazy lazy = this;
        synchronized (lazy) {
            this.memorized = false;
            this.value = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Lazy lazy = this;
        synchronized (lazy) {
            if (this.memorized) {
                return this.value;
            }
            this.memorized = true;
            this.value = this.supplier.get();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T value) {
        Lazy lazy = this;
        synchronized (lazy) {
            if (this.memorized) {
                throw new IllegalStateException(String.format("cannot set value '%s' on Lazy that has already memoized a value", "" + value));
            }
            this.memorized = true;
            this.value = value;
        }
    }
}

