/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.internal.function.Calculator;
import tech.units.indriya.internal.function.ScaleHelper;
import tech.units.indriya.quantity.Quantities;

public class NumberQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final long serialVersionUID = -6494337491031528402L;
    private final Number value;

    protected NumberQuantity(Number number, Unit<Q> unit, Quantity.Scale sc) {
        super(unit, sc);
        this.value = Calculator.of(number).peek();
    }

    protected NumberQuantity(Number number, Unit<Q> unit) {
        this(number, unit, Quantity.Scale.ABSOLUTE);
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        return ScaleHelper.addition(this, that, (thisValue, thatValue) -> Calculator.of(thisValue).add((Number)thatValue).peek());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        return ScaleHelper.addition(this, that, (thisValue, thatValue) -> Calculator.of(thisValue).subtract((Number)thatValue).peek());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return ScaleHelper.multiplication(this, that, (thisValue, thatValue) -> Calculator.of(thisValue).divide((Number)thatValue).peek(), (thisUnit, thatUnit) -> thisUnit.divide(thatUnit));
    }

    @Override
    public ComparableQuantity<Q> divide(Number divisor) {
        return ScaleHelper.scalarMultiplication(this, thisValue -> Calculator.of(thisValue).divide(divisor).peek());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return ScaleHelper.multiplication(this, that, (thisValue, thatValue) -> Calculator.of(thisValue).multiply((Number)thatValue).peek(), (thisUnit, thatUnit) -> thisUnit.multiply(thatUnit));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number factor) {
        return ScaleHelper.scalarMultiplication(this, thisValue -> Calculator.of(thisValue).multiply(factor).peek());
    }

    @Override
    public ComparableQuantity<?> inverse() {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).reciprocal().peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit().inverse(), this.getScale());
    }

    public Quantity<Q> negate() {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).negate().peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit(), this.getScale());
    }

    @Override
    public Number getValue() {
        return this.value;
    }
}

