/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.measure.MeasurementException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.units.indriya.internal.function.Calculator;
import tech.units.indriya.internal.function.radix.MixedRadixSupport;
import tech.units.indriya.internal.function.radix.Radix;
import tech.units.indriya.quantity.CompoundQuantity;
import tech.units.indriya.quantity.Quantities;

public class MixedRadix<Q extends Quantity<Q>> {
    private final PrimaryUnitPickState pickState;
    private final Unit<Q> primaryUnit;
    private final List<Unit<Q>> mixedRadixUnits;
    private final MixedRadixSupport mixedRadixSupport;
    public static final PrimaryUnitPick PRIMARY_UNIT_PICK_DEFAULT;
    public static PrimaryUnitPick PRIMARY_UNIT_PICK;

    public String toString() {
        return "MixedRadix [units=" + this.mixedRadixUnits + "]";
    }

    public static <X extends Quantity<X>> MixedRadix<X> of(Unit<X> leadingUnit) {
        Objects.requireNonNull(leadingUnit);
        return new MixedRadix(PrimaryUnitPickState.pickByConvention(), Collections.singletonList(leadingUnit));
    }

    @SafeVarargs
    public static <X extends Quantity<X>> MixedRadix<X> of(Unit<X> ... units) {
        if (units == null || units.length < 1) {
            throw new IllegalArgumentException("at least the leading unit is required");
        }
        return MixedRadix.of(Arrays.asList(units));
    }

    public static <X extends Quantity<X>> MixedRadix<X> of(Collection<Unit<X>> units) {
        if (units == null || units.size() < 1) {
            throw new IllegalArgumentException("at least the leading unit is required");
        }
        MixedRadix<X> mixedRadix = null;
        for (Unit<X> unit : units) {
            mixedRadix = mixedRadix == null ? MixedRadix.of(unit) : mixedRadix.mix(unit);
        }
        return mixedRadix;
    }

    public static <X extends Quantity<X>> MixedRadix<X> ofPrimary(Unit<X> primaryUnit) {
        Objects.requireNonNull(primaryUnit);
        return new MixedRadix(PrimaryUnitPickState.pickLeading(), Collections.singletonList(primaryUnit));
    }

    public MixedRadix<Q> mix(Unit<Q> mixedRadixUnit) {
        Objects.requireNonNull(mixedRadixUnit);
        return this.append(this.pickState, mixedRadixUnit);
    }

    public MixedRadix<Q> mixPrimary(Unit<Q> mixedRadixUnit) {
        this.pickState.assertNotExplicitlyPicked();
        Objects.requireNonNull(mixedRadixUnit);
        return this.append(PrimaryUnitPickState.pickByExplicitIndex(this.getUnitCount()), mixedRadixUnit);
    }

    public Unit<Q> getPrimaryUnit() {
        return this.primaryUnit;
    }

    private Unit<Q> getTrailingUnit() {
        return this.mixedRadixUnits.get(this.mixedRadixUnits.size() - 1);
    }

    public List<Unit<Q>> getUnits() {
        return Collections.unmodifiableList(this.mixedRadixUnits);
    }

    private int getUnitCount() {
        return this.mixedRadixUnits.size();
    }

    public Quantity<Q> createQuantity(Number[] values, Quantity.Scale scale) {
        Objects.requireNonNull(scale);
        this.guardAgainstIllegalNumbersArgument(values);
        Number sum = this.mixedRadixSupport.sumMostSignificant(values);
        return Quantities.getQuantity(sum, this.getTrailingUnit(), scale).to((Unit)this.getPrimaryUnit());
    }

    public Quantity<Q> createQuantity(Number ... values) {
        return this.createQuantity(values, Quantity.Scale.ABSOLUTE);
    }

    public CompoundQuantity<Q> createCompoundQuantity(Number[] values, Quantity.Scale scale) {
        Objects.requireNonNull(scale);
        this.guardAgainstIllegalNumbersArgument(values);
        ArrayList quantities = new ArrayList();
        for (int i = 0; i < values.length; ++i) {
            quantities.add(Quantities.getQuantity(values[i], this.mixedRadixUnits.get(i), scale));
        }
        return CompoundQuantity.of(quantities);
    }

    public CompoundQuantity<Q> createCompoundQuantity(Number ... values) {
        return this.createCompoundQuantity(values, Quantity.Scale.ABSOLUTE);
    }

    public Number[] extractValues(Quantity<Q> quantity) {
        Objects.requireNonNull(quantity);
        Number[] target = new Number[this.mixedRadixUnits.size()];
        return this.extractValuesInto(quantity, target);
    }

    public Number[] extractValuesInto(Quantity<Q> quantity, Number[] target) {
        Objects.requireNonNull(quantity);
        Objects.requireNonNull(target);
        this.visitQuantity(quantity, target.length, (index, unit, value) -> {
            target[index] = value;
        });
        return target;
    }

    private void guardAgainstIllegalNumbersArgument(Number[] values) {
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("at least the leading unit's number is required");
        }
        int totalValuesGiven = values.length;
        int totalValuesAllowed = this.mixedRadixUnits.size();
        if (totalValuesGiven > totalValuesAllowed) {
            String message = String.format("number of values given <%d> exceeds the number of mixed-radix units available <%d>", totalValuesGiven, totalValuesAllowed);
            throw new IllegalArgumentException(message);
        }
    }

    void visitQuantity(Quantity<Q> quantity, int maxPartsToVisit, MixedRadixVisitor<Q> partVisitor) {
        int partsToVisitCount = Math.min(maxPartsToVisit, this.getUnitCount());
        if (partsToVisitCount == 0) {
            return;
        }
        Number value_inTrailingUnits = quantity.to(this.getTrailingUnit()).getValue();
        ArrayList extractedValues = new ArrayList(this.getUnitCount());
        this.mixedRadixSupport.visitRadixNumbers(value_inTrailingUnits, extractedValues::add);
        for (int i = 0; i < partsToVisitCount; ++i) {
            int invertedIndex = this.getUnitCount() - 1 - i;
            partVisitor.accept(i, this.mixedRadixUnits.get(i), (Number)extractedValues.get(invertedIndex));
        }
    }

    private MixedRadix(PrimaryUnitPickState pickState, List<Unit<Q>> mixedRadixUnits) {
        this.pickState = pickState;
        this.mixedRadixUnits = mixedRadixUnits;
        this.primaryUnit = mixedRadixUnits.get(pickState.nonNegativePrimaryUnitIndex(this.getUnitCount()));
        Radix[] radices = new Radix[this.getUnitCount() - 1];
        for (int i = 0; i < radices.length; ++i) {
            Unit<Q> higher = mixedRadixUnits.get(i);
            Unit<Q> lesser = mixedRadixUnits.get(i + 1);
            radices[i] = this.toRadix(higher.getConverterTo(lesser));
        }
        this.mixedRadixSupport = new MixedRadixSupport(radices);
    }

    private Radix toRadix(UnitConverter converter) {
        return Radix.ofMultiplyConverter(converter);
    }

    private MixedRadix<Q> append(PrimaryUnitPickState state, Unit<Q> mixedRadixUnit) {
        Unit<Q> tail = this.getTrailingUnit();
        this.assertDecreasingOrderOfSignificanceAndLinearity(tail, mixedRadixUnit);
        ArrayList<Unit<Q>> mixedRadixUnits = new ArrayList<Unit<Q>>(this.mixedRadixUnits);
        mixedRadixUnits.add(mixedRadixUnit);
        return new MixedRadix<Q>(state, mixedRadixUnits);
    }

    private void assertDecreasingOrderOfSignificanceAndLinearity(Unit<Q> tail, Unit<Q> appended) {
        UnitConverter converter = appended.getConverterTo(tail);
        if (!converter.isLinear()) {
            String message = String.format("the appended mixed-radix unit <%s> must be linear", appended.getClass());
            throw new IllegalArgumentException(message);
        }
        Double factor = appended.getConverterTo(tail).convert(1.0);
        if (Calculator.of(factor).abs().isLessThanOne()) {
            String message = String.format("the appended mixed-radix unit <%s> must be of lesser significance than the one it is appended to: <%s>", appended.getClass(), tail.getClass());
            throw new MeasurementException(message);
        }
    }

    static {
        PRIMARY_UNIT_PICK = PRIMARY_UNIT_PICK_DEFAULT = PrimaryUnitPick.TRAILING_UNIT;
    }

    private static class PrimaryUnitPickState {
        private static final int LEADING_IS_PRIMARY_UNIT = 0;
        private static final int TRAILING_IS_PRIMARY_UNIT = -1;
        private final boolean explicitlyPicked;
        private final int pickedIndex;

        private static PrimaryUnitPickState pickByConvention() {
            int pickedIndex_byConvention;
            switch (PRIMARY_UNIT_PICK) {
                case LEADING_UNIT: {
                    pickedIndex_byConvention = 0;
                    break;
                }
                case TRAILING_UNIT: {
                    pickedIndex_byConvention = -1;
                    break;
                }
                default: {
                    throw new MeasurementException(String.format("internal error: unmatched switch case <%s>", new Object[]{PRIMARY_UNIT_PICK}));
                }
            }
            return new PrimaryUnitPickState(false, pickedIndex_byConvention);
        }

        private void assertNotExplicitlyPicked() {
            if (this.explicitlyPicked) {
                throw new IllegalStateException("a primary unit was already picked");
            }
        }

        private static PrimaryUnitPickState pickByExplicitIndex(int explicitIndex) {
            return new PrimaryUnitPickState(true, explicitIndex);
        }

        private static PrimaryUnitPickState pickLeading() {
            return new PrimaryUnitPickState(true, 0);
        }

        private PrimaryUnitPickState(boolean explicitlyPicked, int pickedIndex) {
            this.explicitlyPicked = explicitlyPicked;
            this.pickedIndex = pickedIndex;
        }

        private int nonNegativePrimaryUnitIndex(int unitCount) {
            return this.pickedIndex < 0 ? unitCount + this.pickedIndex : this.pickedIndex;
        }
    }

    @FunctionalInterface
    public static interface MixedRadixVisitor<Q extends Quantity<Q>> {
        public void accept(int var1, Unit<Q> var2, Number var3);
    }

    public static enum PrimaryUnitPick {
        LEADING_UNIT,
        TRAILING_UNIT;

    }
}

