/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.measure.MeasurementException;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.function.MixedRadix;
import tech.uom.lib.common.function.QuantityConverter;

public class CompoundQuantity<Q extends Quantity<Q>>
implements QuantityConverter<Q>,
Serializable {
    private static final long serialVersionUID = 5863961588282485676L;
    private final Map<Unit<Q>, Quantity<Q>> quantMap = new LinkedHashMap<Unit<Q>, Quantity<Q>>();

    protected CompoundQuantity(List<Quantity<Q>> quantities) {
        Objects.requireNonNull(quantities);
        Quantity.Scale firstScale = quantities.get(0).getScale();
        for (Quantity<Q> q : quantities) {
            if (firstScale.equals((Object)q.getScale())) {
                this.quantMap.put(q.getUnit(), q);
                continue;
            }
            throw new MeasurementException("Quantities do not have the same scale.");
        }
    }

    @SafeVarargs
    public static <Q extends Quantity<Q>> CompoundQuantity<Q> of(Quantity<Q> ... quantities) {
        return CompoundQuantity.of(Arrays.asList(quantities));
    }

    public static <Q extends Quantity<Q>> CompoundQuantity<Q> of(List<Quantity<Q>> quantities) {
        return new CompoundQuantity<Q>(quantities);
    }

    public Set<Unit<Q>> getUnits() {
        return this.quantMap.keySet();
    }

    public Collection<Quantity<Q>> getQuantities() {
        return this.quantMap.values();
    }

    public Quantity<Q> get(Unit<Q> unit) {
        return this.quantMap.get(unit);
    }

    public String toString() {
        return SimpleQuantityFormat.getInstance().format(this);
    }

    public Quantity<Q> to(Unit<Q> unit) {
        if (this.quantMap.isEmpty()) {
            throw new IllegalArgumentException("No quantity found, cannot convert an empty value");
        }
        MixedRadix mixedRadix = MixedRadix.of(this.getUnits());
        Number[] values = this.getQuantities().stream().map(Quantity::getValue).collect(Collectors.toList()).toArray(new Number[0]);
        return mixedRadix.createQuantity(values).to(unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CompoundQuantity) {
            CompoundQuantity c = (CompoundQuantity)obj;
            return Objects.equals(this.quantMap, c.quantMap);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.quantMap);
    }
}

