/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.radix;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import tech.units.indriya.function.Calculus;

public interface Radix {
    public Number multiply(Number var1);

    public Number[] divideAndRemainder(Number var1, MathContext var2, boolean var3);

    public static class RationalRadix
    implements Radix {
        private final BigInteger r_dividend;
        private final BigInteger r_divisor;
        private final DecimalRadix decimalRadix;

        public RationalRadix(BigInteger r_dividend, BigInteger r_divisor) {
            this.r_dividend = r_dividend;
            this.r_divisor = r_divisor;
            BigDecimal r = Calculus.toBigDecimal(r_dividend).divide(Calculus.toBigDecimal(r_divisor));
            this.decimalRadix = new DecimalRadix(r);
        }

        @Override
        public Number multiply(Number number) {
            BigInteger[] divideAndRemainder;
            BigInteger remainder;
            if (Calculus.isNonFractional(number) && BigInteger.ZERO.equals(remainder = (divideAndRemainder = Calculus.toBigInteger(number).multiply(this.r_dividend).divideAndRemainder(this.r_divisor))[1])) {
                return divideAndRemainder[0];
            }
            return this.decimalRadix.multiply(number);
        }

        @Override
        public Number[] divideAndRemainder(Number number, MathContext mc, boolean fractionalDivide) {
            if (Calculus.isNonFractional(number)) {
                return Calculus.toBigInteger(number).multiply(this.r_divisor).divideAndRemainder(this.r_dividend);
            }
            return this.decimalRadix.divideAndRemainder(number, mc, fractionalDivide);
        }
    }

    public static class DecimalRadix
    implements Radix {
        private final BigDecimal r;

        public DecimalRadix(BigDecimal r) {
            this.r = r;
        }

        @Override
        public Number multiply(Number number) {
            return Calculus.toBigDecimal(number).multiply(this.r);
        }

        @Override
        public Number[] divideAndRemainder(Number number, MathContext mc, boolean fractionalRemainder) {
            BigDecimal[] result = Calculus.toBigDecimal(number).divideAndRemainder(this.r, mc);
            return new Number[]{this.toNonFractional(result[0]), fractionalRemainder ? result[1] : this.toNonFractional(result[1])};
        }

        private Number toNonFractional(BigDecimal bigDecimal) {
            try {
                return bigDecimal.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                return bigDecimal;
            }
        }
    }
}

