/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.radix;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.function.Consumer;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.internal.function.radix.Radix;

public class MixedRadixSupport {
    private final Radix[] radices;
    private final MathContext mc;

    public MixedRadixSupport(Radix[] radices) {
        this.radices = radices;
        this.mc = new MathContext(Calculus.MATH_CONTEXT.getPrecision(), RoundingMode.FLOOR);
    }

    public void visitRadixNumbers(Number trailingRadixValue, Consumer<Number> numberVisitor) {
        Number total = trailingRadixValue;
        for (int i = 0; i < this.radices.length; ++i) {
            Radix radix = this.radices[this.invertIndex(i)];
            boolean fractionalRemainder = i == 0;
            Number[] divideAndRemainder = radix.divideAndRemainder(total, this.mc, fractionalRemainder);
            Number remainder = divideAndRemainder[1];
            numberVisitor.accept(remainder);
            total = divideAndRemainder[0];
        }
        numberVisitor.accept(total);
    }

    public Number sumMostSignificant(Number[] values) {
        int maxAllowedValueIndex = values.length - 1;
        Number sum = values[0];
        for (int i = 0; i < this.radices.length; ++i) {
            sum = this.radices[i].multiply(sum);
            if (i >= maxAllowedValueIndex) continue;
            sum = Calculus.add(sum, values[i + 1]);
        }
        return sum;
    }

    private int invertIndex(int index) {
        return this.radices.length - index - 1;
    }
}

