/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.calc;

import java.util.Objects;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.NumberSystem;

public class Calculator {
    private final NumberSystem ns;
    private Number acc = 0;

    public static Calculator getDefault() {
        return new Calculator(Calculus.NUMBER_SYSTEM);
    }

    public static Calculator loadDefault(Number number) {
        return Calculator.getDefault().load(number);
    }

    private Calculator(NumberSystem ns) {
        this.ns = ns;
    }

    public Calculator load(Number number) {
        Objects.requireNonNull(number);
        this.acc = number;
        return this;
    }

    public Calculator add(Number number) {
        Objects.requireNonNull(number);
        this.acc = this.ns.add(this.acc, number);
        return this;
    }

    public Calculator subtract(Number number) {
        Objects.requireNonNull(number);
        this.acc = this.ns.subtract(this.acc, number);
        return this;
    }

    public Calculator multiply(Number number) {
        this.acc = this.ns.multiply(this.acc, number);
        return this;
    }

    public Calculator divide(Number number) {
        this.acc = this.ns.divide(this.acc, number);
        return this;
    }

    public Calculator negate() {
        this.acc = this.ns.negate(this.acc);
        return this;
    }

    public Calculator reciprocal() {
        this.acc = this.ns.reciprocal(this.acc);
        return this;
    }

    public Number peek() {
        return this.ns.narrow(this.acc);
    }
}

