/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import tech.units.indriya.function.Calculus;

public class RationalNumber
extends Number {
    private static final long serialVersionUID = 1L;
    private final Object $lock1 = new Object[0];
    private final Object $lock2 = new Object[0];
    private final int signum;
    private final BigInteger absDividend;
    private final BigInteger absDivisor;
    private final int hashCode;
    private final boolean isInteger;
    private transient BigDecimal divisionResult;
    private transient Long longValue;
    public static final RationalNumber ZERO = RationalNumber.ofInteger(BigInteger.ZERO);
    public static final RationalNumber ONE = RationalNumber.ofInteger(BigInteger.ONE);

    public static RationalNumber ofInteger(long number) {
        return RationalNumber.ofInteger(BigInteger.valueOf(number));
    }

    public static RationalNumber ofInteger(BigInteger number) {
        Objects.requireNonNull(number);
        return new RationalNumber(number.signum(), number.abs(), BigInteger.ONE);
    }

    public static RationalNumber of(long dividend, long divisor) {
        return RationalNumber.of(BigInteger.valueOf(dividend), BigInteger.valueOf(divisor));
    }

    public static RationalNumber of(BigInteger dividend, BigInteger divisor) {
        int signumDivisor;
        Objects.requireNonNull(dividend);
        Objects.requireNonNull(divisor);
        if (BigInteger.ONE.equals(divisor)) {
            return RationalNumber.ofInteger(dividend);
        }
        if (BigInteger.ZERO.equals(divisor)) {
            throw new IllegalArgumentException("cannot initalize a rational number with divisor equal to ZERO");
        }
        int signumDividend = dividend.signum();
        int signum = signumDividend * (signumDivisor = divisor.signum());
        if (signum == 0) {
            return ZERO;
        }
        BigInteger absDividend = dividend.abs();
        BigInteger absDivisor = divisor.abs();
        BigInteger gcd = absDividend.gcd(absDivisor);
        return new RationalNumber(signum, absDividend.divide(gcd), absDivisor.divide(gcd));
    }

    private RationalNumber(int signum, BigInteger absDividend, BigInteger absDivisor) {
        this.signum = signum;
        this.absDividend = absDividend;
        this.absDivisor = absDivisor;
        this.hashCode = Objects.hash(signum, absDividend, absDivisor);
        this.isInteger = BigInteger.ONE.equals(absDivisor);
    }

    public BigInteger getDividend() {
        return this.signum < 0 ? this.absDividend.negate() : this.absDividend;
    }

    public BigInteger getDivisor() {
        return this.absDivisor;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public int signum() {
        return this.signum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal bigDecimalValue() {
        Object object = this.$lock1;
        synchronized (object) {
            if (this.divisionResult == null) {
                this.divisionResult = new BigDecimal(this.absDividend).divide(new BigDecimal(this.absDivisor), Calculus.MATH_CONTEXT);
                if (this.signum < 0) {
                    this.divisionResult = this.divisionResult.negate();
                }
            }
        }
        return this.divisionResult;
    }

    public RationalNumber add(RationalNumber that) {
        BigInteger a = this.absDividend;
        BigInteger b = this.absDivisor;
        BigInteger c = that.absDividend;
        BigInteger d = that.absDivisor;
        if (this.signum < 0) {
            a = a.negate();
        }
        if (that.signum < 0) {
            c = c.negate();
        }
        return RationalNumber.of(a.multiply(d).add(b.multiply(c)), b.multiply(d));
    }

    public RationalNumber subtract(RationalNumber that) {
        return this.add(that.negate());
    }

    public RationalNumber multiply(RationalNumber that) {
        int productSignum = this.signum * that.signum;
        if (productSignum == 0) {
            return ZERO;
        }
        BigInteger a = this.absDividend;
        BigInteger b = this.absDivisor;
        BigInteger c = that.absDividend;
        BigInteger d = that.absDivisor;
        return new RationalNumber(productSignum, a.multiply(c), b.multiply(d));
    }

    public RationalNumber divide(RationalNumber that) {
        return this.multiply(that.reciprocal());
    }

    public RationalNumber negate() {
        return new RationalNumber(-this.signum, this.absDividend, this.absDivisor);
    }

    public RationalNumber reciprocal() {
        return new RationalNumber(this.signum, this.absDivisor, this.absDividend);
    }

    public int compareTo(RationalNumber that) {
        int comp = Integer.compare(this.signum, that.signum);
        if (comp != 0) {
            return comp;
        }
        if (comp == 0 && this.signum == 0) {
            return 0;
        }
        BigInteger a = this.absDividend;
        BigInteger b = this.absDivisor;
        BigInteger c = that.absDividend;
        BigInteger d = that.absDivisor;
        BigInteger ad = a.multiply(d);
        BigInteger bc = b.multiply(c);
        int absCompare = ad.compareTo(bc);
        return this.signum > 0 ? absCompare : -absCompare;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long longValue() {
        Object object = this.$lock2;
        synchronized (object) {
            if (this.longValue == null) {
                this.longValue = this.signum() < 0 ? this.absDividend.negate().divide(this.absDivisor).longValue() : this.absDividend.divide(this.absDivisor).longValue();
            }
        }
        return this.longValue;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }
}

