/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.Prefix;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.RationalConverter;
import tech.uom.lib.common.function.IntBaseSupplier;
import tech.uom.lib.common.function.IntExponentSupplier;

public final class PowerOfIntConverter
extends AbstractConverter
implements IntBaseSupplier,
IntExponentSupplier {
    private static final long serialVersionUID = 3546932001671571300L;
    private final int base;
    private final int exponent;
    private final int hashCode;
    private final double doubleFactor;

    public static PowerOfIntConverter of(Prefix prefix) {
        return new PowerOfIntConverter(prefix.getBase(), prefix.getExponent());
    }

    public static PowerOfIntConverter of(int base, int exponent) {
        return new PowerOfIntConverter(base, exponent);
    }

    protected PowerOfIntConverter(int base, int exponent) {
        if (base == 0) {
            throw new IllegalArgumentException("base cannot be zero (because 0^0 is undefined)");
        }
        this.base = base;
        this.exponent = exponent;
        this.doubleFactor = Math.pow(base, exponent);
        this.hashCode = Objects.hash(base, exponent);
    }

    public int getBase() {
        return this.base;
    }

    public int getExponent() {
        return this.exponent;
    }

    public boolean isIdentity() {
        if (this.base == 1) {
            return true;
        }
        return this.exponent == 0;
    }

    public boolean isLinear() {
        return true;
    }

    @Override
    protected boolean canReduceWith(AbstractConverter that) {
        if (that instanceof PowerOfIntConverter) {
            return ((PowerOfIntConverter)that).base == this.base;
        }
        return that instanceof RationalConverter;
    }

    @Override
    protected AbstractConverter reduce(AbstractConverter that) {
        if (that instanceof PowerOfIntConverter) {
            PowerOfIntConverter other = (PowerOfIntConverter)that;
            if (this.base == other.base) {
                return this.composeSameBaseNonIdentity(other);
            }
        }
        if (that instanceof RationalConverter) {
            return (AbstractConverter)this.toRationalConverter().concatenate(that);
        }
        throw new IllegalStateException(String.format("%s.simpleCompose() not handled for converter %s", this, that));
    }

    @Override
    public AbstractConverter inverseWhenNotIdentity() {
        return new PowerOfIntConverter(this.base, -this.exponent);
    }

    @Override
    protected Number convertWhenNotIdentity(BigInteger value, MathContext ctx) {
        BigInteger bintFactor = BigInteger.valueOf(this.base).pow(Math.abs(this.exponent));
        if (this.exponent > 0) {
            return bintFactor.multiply(value);
        }
        BigInteger[] divideAndRemainder = value.divideAndRemainder(bintFactor);
        BigInteger divisionResult = divideAndRemainder[0];
        BigInteger divisionRemainder = divideAndRemainder[1];
        if (BigInteger.ZERO.compareTo(divisionRemainder) == 0) {
            return divisionResult;
        }
        BigDecimal bdecFactor = new BigDecimal(bintFactor);
        BigDecimal bdecValue = new BigDecimal(value);
        return bdecValue.divide(bdecFactor, Calculus.MATH_CONTEXT);
    }

    @Override
    public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) throws ArithmeticException {
        BigDecimal bdecFactor = new BigDecimal(BigInteger.valueOf(this.base).pow(Math.abs(this.exponent)));
        BigDecimal bdecValue = value;
        return this.exponent > 0 ? bdecValue.multiply(bdecFactor, ctx) : bdecValue.divide(bdecFactor, ctx);
    }

    @Override
    public double convertWhenNotIdentity(double value) {
        return value * this.doubleFactor;
    }

    @Override
    public boolean equals(Object obj) {
        UnitConverter other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnitConverter) {
            other = (UnitConverter)obj;
            if (this.isIdentity() && other.isIdentity()) {
                return true;
            }
        }
        if (obj instanceof PowerOfIntConverter) {
            other = (PowerOfIntConverter)obj;
            return this.base == other.base && this.exponent == other.exponent;
        }
        return false;
    }

    @Override
    public final String transformationLiteral() {
        if (this.base < 0) {
            return String.format("x -> x * (%s)^%s", this.base, this.exponent);
        }
        return String.format("x -> x * %s^%s", this.base, this.exponent);
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (this.isIdentity() && o.isIdentity()) {
            return 0;
        }
        if (o instanceof PowerOfIntConverter) {
            PowerOfIntConverter other = (PowerOfIntConverter)o;
            int c = Integer.compare(this.base, other.base);
            if (c != 0) {
                return c;
            }
            return Integer.compare(this.exponent, other.exponent);
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private PowerOfIntConverter composeSameBaseNonIdentity(PowerOfIntConverter other) {
        return new PowerOfIntConverter(this.base, this.exponent + other.exponent);
    }

    public RationalConverter toRationalConverter() {
        return this.exponent > 0 ? new RationalConverter(BigInteger.valueOf(this.base).pow(this.exponent), BigInteger.ONE) : new RationalConverter(BigInteger.ONE, BigInteger.valueOf(this.base).pow(-this.exponent));
    }
}

