/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.measure.Prefix;
import javax.measure.UnitConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.ConverterCompositionHandler;
import tech.units.indriya.function.PowerOfIntConverter;
import tech.uom.lib.common.function.Converter;
import tech.uom.lib.common.util.UnitComparator;

public abstract class AbstractConverter
implements UnitConverter,
Converter<Number, Number>,
Serializable,
Comparable<UnitConverter> {
    private static final long serialVersionUID = 5790242858468427131L;
    public static final AbstractConverter IDENTITY = new Identity();
    public static ConverterCompositionHandler UNIT_COMPOSITION_HANDLER = ConverterCompositionHandler.yieldingNormalForm();
    protected List<? extends UnitConverter> conversionSteps;

    protected AbstractConverter() {
    }

    public static UnitConverter of(Prefix prefix) {
        return PowerOfIntConverter.of(prefix);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected abstract String transformationLiteral();

    public final String toString() {
        String converterName = this.getClass().getSimpleName();
        if (converterName.endsWith("Converter")) {
            converterName = converterName.substring(0, converterName.length() - "Converter".length());
        }
        if (this.isIdentity()) {
            return String.format("%s(IDENTITY)", converterName);
        }
        String transformationLiteral = this.transformationLiteral();
        if (transformationLiteral == null || transformationLiteral.length() == 0) {
            return String.format("%s", converterName);
        }
        return String.format("%s(%s)", converterName, transformationLiteral);
    }

    protected abstract AbstractConverter inverseWhenNotIdentity();

    public final AbstractConverter inverse() {
        if (this.isIdentity()) {
            return this;
        }
        return this.inverseWhenNotIdentity();
    }

    protected abstract boolean canReduceWith(AbstractConverter var1);

    protected AbstractConverter reduce(AbstractConverter that) {
        throw new IllegalStateException(String.format("Concrete UnitConverter '%s' does not implement reduce(...).", this));
    }

    public final UnitConverter concatenate(UnitConverter converter) {
        Objects.requireNonNull(converter, "Cannot compose with converter that is null.");
        if (converter instanceof AbstractConverter) {
            AbstractConverter other = (AbstractConverter)converter;
            return UNIT_COMPOSITION_HANDLER.compose(this, other, AbstractConverter::canReduceWith, AbstractConverter::reduce);
        }
        if (converter.isIdentity()) {
            return this;
        }
        if (this.isIdentity()) {
            return converter;
        }
        return new Pair(this, converter);
    }

    public final List<? extends UnitConverter> getConversionSteps() {
        if (this.conversionSteps != null) {
            return this.conversionSteps;
        }
        if (this instanceof Pair) {
            this.conversionSteps = ((Pair)this).createConversionSteps();
            return this.conversionSteps;
        }
        this.conversionSteps = Collections.singletonList(this);
        return this.conversionSteps;
    }

    protected abstract double convertWhenNotIdentity(double var1);

    protected Number convertWhenNotIdentity(BigInteger value, MathContext ctx) {
        return this.convertWhenNotIdentity(new BigDecimal(value), ctx);
    }

    protected abstract BigDecimal convertWhenNotIdentity(BigDecimal var1, MathContext var2);

    public final double convert(double value) {
        if (this.isIdentity()) {
            return value;
        }
        return this.convertWhenNotIdentity(value);
    }

    public final Number convert(Number value) {
        if (this.isIdentity()) {
            return value;
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (value instanceof BigDecimal) {
            return this.convertWhenNotIdentity((BigDecimal)value, Calculus.MATH_CONTEXT);
        }
        if (value instanceof BigInteger) {
            return this.convertWhenNotIdentity((BigInteger)value, Calculus.MATH_CONTEXT);
        }
        return this.convertWhenNotIdentity(value.doubleValue());
    }

    public static final class Pair
    extends AbstractConverter
    implements Serializable {
        private static final Comparator unitComparator = new UnitComparator();
        private static final long serialVersionUID = -123063827821728331L;
        private final UnitConverter left;
        private final UnitConverter right;

        public Pair(UnitConverter left, UnitConverter right) {
            if (left == null || right == null) {
                throw new IllegalArgumentException("Converters cannot be null");
            }
            this.left = left;
            this.right = right;
        }

        public boolean isLinear() {
            return this.left.isLinear() && this.right.isLinear();
        }

        public boolean isIdentity() {
            return false;
        }

        protected List<? extends UnitConverter> createConversionSteps() {
            List leftSteps = this.left.getConversionSteps();
            List rightSteps = this.right.getConversionSteps();
            ArrayList steps = new ArrayList(leftSteps.size() + rightSteps.size());
            steps.addAll(leftSteps);
            steps.addAll(rightSteps);
            return steps;
        }

        @Override
        public Pair inverseWhenNotIdentity() {
            return new Pair(this.right.inverse(), this.left.inverse());
        }

        @Override
        public double convertWhenNotIdentity(double value) {
            return this.left.convert(this.right.convert(value));
        }

        @Override
        public Number convertWhenNotIdentity(BigInteger value, MathContext ctx) {
            if (this.right instanceof AbstractConverter) {
                AbstractConverter absLeft = (AbstractConverter)this.left;
                AbstractConverter absRight = (AbstractConverter)this.right;
                Number rightValue = absRight.convertWhenNotIdentity(value, ctx);
                if (rightValue instanceof BigDecimal) {
                    return absLeft.convertWhenNotIdentity((BigDecimal)rightValue, ctx);
                }
                if (rightValue instanceof BigInteger) {
                    return absLeft.convertWhenNotIdentity((BigInteger)rightValue, ctx);
                }
                return absLeft.convertWhenNotIdentity(Calculus.toBigDecimal(rightValue), ctx);
            }
            return this.convertWhenNotIdentity(new BigDecimal(value), ctx);
        }

        @Override
        public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) {
            if (this.right instanceof AbstractConverter) {
                AbstractConverter _left = (AbstractConverter)this.left;
                AbstractConverter _right = (AbstractConverter)this.right;
                return _left.convertWhenNotIdentity(_right.convertWhenNotIdentity(value, ctx), ctx);
            }
            return Calculus.toBigDecimal(this.left.convert(this.right.convert((Number)value)));
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Pair) {
                Pair that = (Pair)obj;
                return Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public UnitConverter getLeft() {
            return this.left;
        }

        public UnitConverter getRight() {
            return this.right;
        }

        @Override
        public int compareTo(UnitConverter obj) {
            if (this == obj) {
                return 0;
            }
            if (obj instanceof Pair) {
                Pair that = (Pair)obj;
                return Objects.compare(this.left, that.left, unitComparator) + Objects.compare(this.right, that.right, unitComparator);
            }
            return -1;
        }

        @Override
        protected String transformationLiteral() {
            return String.format("%s", this.getConversionSteps().stream().map(Object::toString).collect(Collectors.joining(" \u25cb ")));
        }

        @Override
        protected boolean canReduceWith(AbstractConverter that) {
            return false;
        }
    }

    private static final class Identity
    extends AbstractConverter {
        private static final long serialVersionUID = -4460463244427587361L;

        private Identity() {
        }

        public boolean isIdentity() {
            return true;
        }

        @Override
        public double convertWhenNotIdentity(double value) {
            throw this.unreachable();
        }

        @Override
        public Number convertWhenNotIdentity(BigInteger value, MathContext ctx) {
            throw this.unreachable();
        }

        @Override
        public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) {
            throw this.unreachable();
        }

        @Override
        public boolean equals(Object cvtr) {
            return cvtr instanceof Identity;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        public boolean isLinear() {
            return true;
        }

        @Override
        public int compareTo(UnitConverter o) {
            if (o instanceof Identity) {
                return 0;
            }
            return -1;
        }

        @Override
        protected boolean canReduceWith(AbstractConverter that) {
            throw this.unreachable();
        }

        @Override
        protected AbstractConverter reduce(AbstractConverter that) {
            throw this.unreachable();
        }

        @Override
        protected AbstractConverter inverseWhenNotIdentity() {
            throw this.unreachable();
        }

        @Override
        protected String transformationLiteral() {
            return null;
        }

        private IllegalStateException unreachable() {
            return new IllegalStateException("code was reached, that is expected unreachable");
        }
    }
}

