/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.spi;

import java.util.Map;
import javax.measure.Dimension;
import tec.units.indriya.AbstractConverter;
import tec.units.indriya.quantity.QuantityDimension;
import tec.units.indriya.spi.StandardModel;

public abstract class DimensionalModel {
    private static DimensionalModel currentModel = new StandardModel();

    public static DimensionalModel current() {
        return currentModel;
    }

    protected static void setCurrent(DimensionalModel model) {
        currentModel = model;
    }

    protected DimensionalModel() {
    }

    public Dimension getFundamentalDimension(Dimension dimension) {
        Map dimensions = dimension.getBaseDimensions();
        if (dimensions == null) {
            return dimension;
        }
        Dimension fundamentalProduct = QuantityDimension.NONE;
        for (Map.Entry e : dimensions.entrySet()) {
            fundamentalProduct = fundamentalProduct.multiply(this.getFundamentalDimension((Dimension)e.getKey())).pow(((Integer)e.getValue()).intValue());
        }
        return fundamentalProduct;
    }

    public AbstractConverter getDimensionalTransform(Dimension dimension) {
        Map dimensions = dimension.getBaseDimensions();
        if (dimensions == null) {
            return AbstractConverter.IDENTITY;
        }
        AbstractConverter toFundamental = AbstractConverter.IDENTITY;
        for (Map.Entry e : dimensions.entrySet()) {
            AbstractConverter cvtr = this.getDimensionalTransform((Dimension)e.getKey());
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException("Non-linear dimensional transform");
            }
            int pow = (Integer)e.getValue();
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j = 0; j < pow; ++j) {
                toFundamental = toFundamental.concatenate(cvtr);
            }
        }
        return toFundamental;
    }
}

