/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.quantity;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.format.AbstractQuantityFormat;
import tec.units.indriya.format.FormatBehavior;
import tec.units.indriya.quantity.DecimalQuantity;
import tec.units.indriya.quantity.DoubleQuantity;
import tec.units.indriya.quantity.NumberQuantity;

public final class Quantities {
    private Quantities() {
    }

    public static ComparableQuantity<?> getQuantity(CharSequence csq) {
        try {
            return AbstractQuantityFormat.getInstance(FormatBehavior.LOCALE_NEUTRAL).parse(csq, new ParsePosition(0));
        }
        catch (ParserException e) {
            throw new IllegalArgumentException(e.getParsedString());
        }
    }

    public static <Q extends Quantity<Q>> ComparableQuantity<Q> getQuantity(Number value, Unit<Q> unit) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(unit);
        if (Double.class.isInstance(value)) {
            return new DoubleQuantity<Q>((Double)Double.class.cast(value), unit);
        }
        if (BigDecimal.class.isInstance(value)) {
            return new DecimalQuantity<Q>((BigDecimal)BigDecimal.class.cast(value), unit);
        }
        if (BigInteger.class.isInstance(value)) {
            return new DecimalQuantity<Q>(new BigDecimal((BigInteger)BigInteger.class.cast(value)), unit);
        }
        return new NumberQuantity<Q>(value, unit);
    }
}

