/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.indriya.AbstractConverter;
import tec.units.indriya.AbstractQuantity;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.quantity.Quantities;

final class DoubleQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = 8660843078156312278L;
    final double value;

    public DoubleQuantity(double value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? this.value : super.getUnit().getConverterTo(unit).convert(this.value);
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        BigDecimal decimal = BigDecimal.valueOf(this.value);
        return super.getUnit().equals(unit) ? decimal : ((AbstractConverter)super.getUnit().getConverterTo(unit)).convert(decimal, ctx);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value + that.getValue().doubleValue(), this.getUnit());
        }
        Quantity converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value + converted.getValue().doubleValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value - that.getValue().doubleValue(), this.getUnit());
        }
        Quantity converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value - converted.getValue().doubleValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new DoubleQuantity<Q>(this.value * that.getValue().doubleValue(), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return Quantities.getQuantity(this.value * that.doubleValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return new DoubleQuantity<Q>(this.value / that.getValue().doubleValue(), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return Quantities.getQuantity(this.value / that.doubleValue(), this.getUnit());
    }

    @Override
    public AbstractQuantity<Q> inverse() {
        return (AbstractQuantity)Quantities.getQuantity(1.0 / this.value, this.getUnit().inverse());
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

