/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.quantity;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.measure.MeasurementException;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.lib.common.function.QuantityConverter;

public class CompoundQuantity<Q extends Quantity<Q>>
implements QuantityConverter<Q>,
Serializable {
    private static final long serialVersionUID = 5863961588282485676L;
    private final Map<Unit<Q>, Quantity<Q>> quantMap = new LinkedHashMap<Unit<Q>, Quantity<Q>>();

    @SafeVarargs
    protected CompoundQuantity(Quantity<Q> ... quantities) {
        for (Quantity<Q> q : quantities) {
            this.quantMap.put(q.getUnit(), q);
        }
    }

    @SafeVarargs
    public static <Q extends Quantity<Q>> CompoundQuantity<Q> of(Quantity<Q> ... quantities) {
        return new CompoundQuantity<Q>(quantities);
    }

    public Set<Unit<Q>> getUnits() {
        return this.quantMap.keySet();
    }

    public Quantity<Q> get(Unit<Q> unit) {
        return this.quantMap.get(unit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        for (Quantity<Q> q : this.quantMap.values()) {
            sb.append(q);
            if (++pos >= this.quantMap.size()) continue;
            sb.append(": ");
        }
        return sb.toString();
    }

    public Quantity<Q> to(Unit<Q> type) {
        if (this.quantMap.isEmpty()) {
            throw new MeasurementException("No quantity found, cannot convert an empty value");
        }
        Quantity result = null;
        for (Quantity quantity : this.quantMap.values()) {
            if (result == null) {
                result = quantity;
                continue;
            }
            result = result.add(quantity);
        }
        return result.to(type);
    }
}

