/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tec.units.indriya.AbstractConverter;
import tec.uom.lib.common.function.ValueSupplier;

public final class AddConverter
extends AbstractConverter
implements ValueSupplier<Double> {
    private static final long serialVersionUID = -2981335308595652284L;
    private double offset;

    public AddConverter(double offset) {
        if (offset == 0.0) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this.offset = offset;
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (!(converter instanceof AddConverter)) {
            return super.concatenate(converter);
        }
        double newOffset = this.offset + ((AddConverter)converter).offset;
        return newOffset == 0.0 ? IDENTITY : new AddConverter(newOffset);
    }

    @Override
    public AddConverter inverse() {
        return new AddConverter(-this.offset);
    }

    @Override
    public double convert(double value) {
        return value + this.offset;
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.add(BigDecimal.valueOf(this.offset), ctx);
    }

    public final String toString() {
        return "AddConverter(" + this.offset + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AddConverter) {
            AddConverter other = (AddConverter)obj;
            return Objects.equals(this.offset, other.offset);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.offset);
    }

    public boolean isLinear() {
        return false;
    }

    public Double getValue() {
        return this.offset;
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof AddConverter) {
            return this.getValue().compareTo(((AddConverter)o).getValue());
        }
        return -1;
    }
}

