/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotting.fx.FxBuilder;

public class FxBar
extends FxBuilder {
    public static BarChart<String, Number> chart(String title, Table table, String categoryColumnName, String numberColumnName) {
        StringColumn stringColumn = table.stringColumn(categoryColumnName);
        NumberColumn numberColumn = table.nCol(numberColumnName);
        return FxBar.chart(title, stringColumn, numberColumn);
    }

    public static BarChart<String, Number> chart(String title, StringColumn stringColumn, NumberColumn numberColumn) {
        CategoryAxis categoryAxis = FxBar.getCategoryAxis((Column)stringColumn);
        NumberAxis numberAxis = FxBar.getNumberAxis(numberColumn);
        BarChart<String, Number> barChart = FxBar.getBarChart(title, categoryAxis, numberAxis);
        ArrayList<XYChart.Data<String, Number>> data = new ArrayList<XYChart.Data<String, Number>>(stringColumn.size());
        for (int i = 0; i < stringColumn.size(); ++i) {
            data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)stringColumn.get(i), (Object)numberColumn.get(i)));
        }
        barChart.getData().add(FxBar.getSeries(numberColumn, data));
        return barChart;
    }

    public static BarChart<String, Number> chart(String title, NumberColumn categoryColumn, NumberColumn numberColumn) {
        CategoryAxis categoryAxis = FxBar.getCategoryAxis((Column)categoryColumn);
        NumberAxis numberAxis = FxBar.getNumberAxis(numberColumn);
        BarChart<String, Number> barChart = FxBar.getBarChart(title, categoryAxis, numberAxis);
        ArrayList<XYChart.Data<String, Number>> data = new ArrayList<XYChart.Data<String, Number>>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            data.add((XYChart.Data<String, Number>)new XYChart.Data((Object)categoryColumn.getString(i), (Object)numberColumn.get(i)));
        }
        barChart.getData().add(FxBar.getSeries(numberColumn, data));
        return barChart;
    }
}

