/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.xchart;

import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Theme;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.plotting.xchart.TablesawTheme;

public class XchartQuantile {
    public static void show(String chartTitle, NumberColumn yColumn) {
        double[] x = new double[yColumn.size()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = (float)i / (float)x.length;
        }
        NumberColumn copy = yColumn.copy();
        copy.sortAscending();
        XchartQuantile.show(chartTitle, x, copy, 600, 400);
    }

    public static void show(String chartTitle, double[] xData, NumberColumn yColumn, int width, int height) {
        double[] yData = yColumn.asDoubleArray();
        XYChart chart = new XYChart(width, height);
        chart.setTitle(chartTitle);
        chart.setYAxisTitle(yColumn.name());
        ((XYStyler)chart.getStyler()).setTheme((Theme)new TablesawTheme());
        ((XYStyler)chart.getStyler()).setMarkerSize(2);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        XYSeries series = chart.addSeries("Ranked: " + yColumn.name(), xData, yData);
        series.setMarker(SeriesMarkers.CIRCLE);
        new SwingWrapper((Chart)chart).displayChart("Tablesaw");
    }
}

