/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.smile;

import java.awt.Component;
import javax.swing.JFrame;
import smile.plot.BoxPlot;
import smile.plot.PlotCanvas;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotting.smile.SmilePlotUtils;
import tech.tablesaw.table.TemporaryView;
import tech.tablesaw.table.ViewGroup;
import tech.tablesaw.util.DoubleArrays;

public class SmileBox {
    public static void show(String title, ViewGroup data, int columnIndex) {
        PlotCanvas canvas = SmileBox.create(title, data, columnIndex);
        JFrame frame = SmilePlotUtils.getjFrame(600, 400);
        frame.add((Component)canvas);
        frame.setVisible(true);
    }

    public static void show(String title, Table table, String summaryColumnName, String groupingColumnName) {
        PlotCanvas canvas = SmileBox.create(title, table, summaryColumnName, groupingColumnName);
        JFrame frame = SmilePlotUtils.getjFrame(600, 400);
        frame.add((Component)canvas);
        frame.setVisible(true);
    }

    public static PlotCanvas create(String plotTitle, ViewGroup groups, int columnNumber) {
        double[][] dataArray = DoubleArrays.to2dArray((ViewGroup)groups, (int)columnNumber);
        String[] grounpNames = SmileBox.groupNames(groups);
        PlotCanvas canvas = BoxPlot.plot((double[][])dataArray, (String[])grounpNames);
        canvas.setTitle(plotTitle);
        canvas.setAxisLabel(0, "");
        canvas.setAxisLabel(1, groups.getSortedOriginal().column(columnNumber).name());
        return canvas;
    }

    public static PlotCanvas create(String plotTitle, Table table, String summaryColumnName, String groupingColumnName) {
        ViewGroup groups = table.splitOn(new Column[]{table.column(groupingColumnName)});
        int columnNumber = table.columnIndex(summaryColumnName);
        double[][] dataArray = DoubleArrays.to2dArray((ViewGroup)groups, (int)columnNumber);
        String[] grounpNames = SmileBox.groupNames(groups);
        PlotCanvas canvas = BoxPlot.plot((double[][])dataArray, (String[])grounpNames);
        canvas.setTitle(plotTitle);
        canvas.setAxisLabel(0, groupingColumnName);
        canvas.setAxisLabel(1, summaryColumnName);
        return canvas;
    }

    private static String[] groupNames(ViewGroup groups) {
        String[] result = new String[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            TemporaryView view = groups.get(i);
            result[i] = view.name();
        }
        return result;
    }
}

