/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.opencsv.CSVReader;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import tech.tablesaw.plotting.Hue;
import tech.tablesaw.plotting.StandardColor;

public class StandardColors {
    static final ImmutableMultimap<Hue, StandardColor> colorMap = ImmutableMultimap.copyOf(StandardColors.loadColors());
    static ImmutableList<StandardColor> neutralColors = ImmutableList.copyOf(StandardColors.loadNeutrals());

    static Multimap<Hue, StandardColor> loadColors() {
        LinkedListMultimap standards = LinkedListMultimap.create();
        InputStream resourceAsStream = StandardColors.class.getResourceAsStream("/colors.txt");
        try (CSVReader reader = new CSVReader((Reader)new InputStreamReader(resourceAsStream));){
            String[] nextLine;
            while ((nextLine = reader.readNext()) != null) {
                for (String colorData : nextLine) {
                    String vHex;
                    String[] colorSplit = colorData.trim().split(" ");
                    String vHue = colorSplit[0];
                    String valueChroma = colorSplit[1];
                    String[] valueAndChroma = valueChroma.split("/");
                    int vValue = Integer.parseInt(valueAndChroma[0]);
                    int vChroma = Integer.parseInt(valueAndChroma[1]);
                    StandardColor color = new StandardColor(vHue, vChroma, vValue, vHex = colorSplit[2]);
                    if (color.hue().equals((Object)Hue.Neutral)) continue;
                    standards.put((Object)color.hue(), (Object)color);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read predefined colors file", e);
        }
        return standards;
    }

    static List<StandardColor> loadNeutrals() {
        ArrayList<StandardColor> neutrals = new ArrayList<StandardColor>();
        InputStream resourceAsStream = StandardColors.class.getResourceAsStream("/colors.txt");
        try (CSVReader reader = new CSVReader((Reader)new InputStreamReader(resourceAsStream));){
            String[] nextLine;
            while ((nextLine = reader.readNext()) != null) {
                for (String colorData : nextLine) {
                    String vHex;
                    String[] colorSplit = colorData.trim().split(" ");
                    String vHue = colorSplit[0];
                    String valueChroma = colorSplit[1];
                    String[] valueAndChroma = valueChroma.split("/");
                    int vValue = Integer.parseInt(valueAndChroma[0]);
                    int vChroma = Integer.parseInt(valueAndChroma[1]);
                    StandardColor color = new StandardColor(vHue, vChroma, vValue, vHex = colorSplit[2]);
                    if (!color.hue().equals((Object)Hue.Neutral)) continue;
                    neutrals.add(color);
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read predefined colors file", ex);
        }
        return neutrals;
    }

    static ImmutableList<StandardColor> getNeutralColors() {
        return neutralColors;
    }

    static Set<Hue> getHues() {
        return colorMap.keySet();
    }

    static ImmutableCollection<StandardColor> getColors(Hue hue) {
        return colorMap.get((Object)hue);
    }

    public static List<StandardColor> getFilteredColors(Hue hue, Range<Integer> chromaRange, Range<Integer> valueRange) {
        ArrayList<StandardColor> filtered = new ArrayList<StandardColor>();
        ImmutableCollection colors = colorMap.get((Object)hue);
        for (StandardColor color : colors) {
            if (!chromaRange.contains((Comparable)Integer.valueOf(color.chroma())) || !valueRange.contains((Comparable)Integer.valueOf(color.value()))) continue;
            filtered.add(color);
        }
        return filtered;
    }

    static Color[] allGreys() {
        ArrayList<Color> colors = new ArrayList<Color>(11);
        colors.add(Color.WHITE);
        for (StandardColor color : neutralColors) {
            colors.add(color.asColor());
        }
        colors.add(Color.BLACK);
        return colors.toArray(new Color[11]);
    }

    static Color[] ggPlotGreys() {
        ArrayList<Color> colors = new ArrayList<Color>(9);
        for (StandardColor color : neutralColors.subList(1, neutralColors.size())) {
            colors.add(color.asColor());
        }
        colors.add(Color.BLACK);
        return colors.toArray(new Color[9]);
    }

    static Color[] ggPlotGreys(int size) {
        size = Math.min(size, 9);
        ArrayList<Color> colors = new ArrayList<Color>(size);
        int start = neutralColors.size() - size + 1;
        for (StandardColor color : neutralColors.subList(start, neutralColors.size())) {
            colors.add(color.asColor());
        }
        colors.add(Color.BLACK);
        return colors.toArray(new Color[size]);
    }

    static Color[] ggPlotGreys6() {
        int size = 6;
        ArrayList<Color> colors = new ArrayList<Color>(size);
        colors.add(Color.WHITE);
        colors.add(((StandardColor)neutralColors.get(2)).asColor());
        colors.add(((StandardColor)neutralColors.get(4)).asColor());
        colors.add(((StandardColor)neutralColors.get(6)).asColor());
        colors.add(((StandardColor)neutralColors.get(8)).asColor());
        colors.add(Color.BLACK);
        return colors.toArray(new Color[size]);
    }

    static List<Hue> randomHues(int n) {
        int i;
        ArrayList<Hue> resultList = new ArrayList<Hue>(n);
        int huesAvailable = Hue.values().length - 1;
        int maxDistance = huesAvailable / n;
        Random random = new Random();
        int starting = random.nextInt(huesAvailable);
        ArrayList<Hue> hues = new ArrayList<Hue>(huesAvailable);
        for (i = starting; i < huesAvailable; ++i) {
            if (Hue.values()[i] == Hue.Neutral) continue;
            hues.add(Hue.values()[i]);
        }
        for (i = 0; i < starting; ++i) {
            if (Hue.values()[i] == Hue.Neutral) continue;
            hues.add(Hue.values()[i]);
        }
        for (int j = 0; j < huesAvailable && resultList.size() < n; j += maxDistance) {
            resultList.add((Hue)((Object)hues.get(j)));
        }
        return resultList;
    }

    public static List<Color> randomColors(int n) {
        Random random = new Random();
        List<Hue> hues = StandardColors.randomHues(n);
        ArrayList<Color> colors = new ArrayList<Color>(n);
        Range chromaRange = Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(12));
        Range valueRange = Range.closed((Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(8));
        for (Hue hue : hues) {
            List<StandardColor> standardColors = StandardColors.getFilteredColors(hue, (Range<Integer>)chromaRange, (Range<Integer>)valueRange);
            StandardColor randomColor = standardColors.get(random.nextInt(standardColors.size()));
            colors.add(randomColor.asColor());
        }
        return colors;
    }

    public static Color[] standardColorArray() {
        List<Color> standardColors = StandardColors.standardColors();
        return StandardColors.standardColors().toArray(new Color[standardColors.size()]);
    }

    public static List<Color> standardColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(StandardColors.color(Hue.Red_5, 14, 4));
        colors.add(StandardColors.color(Hue.Yellow_2_5, 12, 8));
        colors.add(StandardColors.color(Hue.Purple_7_5, 10, 4));
        colors.add(StandardColors.color(Hue.YellowRed_5, 12, 7));
        colors.add(StandardColors.color(Hue.PurpleBlue_2_5, 6, 8));
        colors.add(StandardColors.color(Hue.Yellow_5, 4, 7));
        colors.add(StandardColors.color(Hue.GreenYellow_5, 2, 5));
        colors.add(StandardColors.color(Hue.Green_2_5, 10, 6));
        colors.add(StandardColors.color(Hue.RedPurple_5, 10, 7));
        colors.add(StandardColors.color(Hue.PurpleBlue_2_5, 8, 4));
        colors.add(StandardColors.color(Hue.Red_7_5, 8, 7));
        colors.add(StandardColors.color(Hue.PurpleBlue_2_5, 10, 4));
        colors.add(StandardColors.color(Hue.YellowRed_7_5, 12, 7));
        colors.add(StandardColors.color(Hue.RedPurple_7_5, 12, 4));
        colors.add(StandardColors.color(Hue.Yellow_10, 10, 8));
        colors.add(StandardColors.color(Hue.YellowRed_2_5, 8, 3));
        colors.add(StandardColors.color(Hue.GreenYellow_5, 10, 7));
        colors.add(StandardColors.color(Hue.Red_10, 14, 5));
        colors.add(StandardColors.color(Hue.GreenYellow_5, 4, 2));
        colors.add(StandardColors.allGreys()[2]);
        return colors;
    }

    @Nullable
    static Color color(Hue hue, int chroma, int value) {
        ImmutableCollection options = colorMap.get((Object)hue);
        for (StandardColor standardColor : options) {
            if (standardColor.chroma() != chroma || standardColor.value() != value) continue;
            return standardColor.asColor();
        }
        return null;
    }
}

