/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class HeatmapTrace
extends AbstractTrace {
    private final Object[] x;
    private final Object[] y;
    private final double[][] z;
    private final String type;

    private HeatmapTrace(HeatmapBuilder builder) {
        super(builder);
        this.x = builder.x;
        this.y = builder.y;
        this.z = builder.z;
        this.type = builder.getType();
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    @Override
    protected Map<String, Object> getContext() {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace0");
        context.put("x", Utils.dataAsString(this.x));
        context.put("y", Utils.dataAsString(this.y));
        context.put("z", Utils.dataAsString(this.z));
        context.put("type", this.type);
        return context;
    }

    public static HeatmapBuilder builder(Object[] x, Object[] y, double[][] z) {
        return new HeatmapBuilder(x, y, z);
    }

    public static class HeatmapBuilder
    extends TraceBuilder {
        private static final String type = "heatmap";
        private final Object[] x;
        private final Object[] y;
        private final double[][] z;

        HeatmapBuilder(Object[] x, Object[] y, double[][] z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public HeatmapBuilder xAxis(String xAxis) {
            super.xAxis(xAxis);
            return this;
        }

        @Override
        public HeatmapBuilder yAxis(String yAxis) {
            super.yAxis(yAxis);
            return this;
        }

        public HeatmapTrace build() {
            return new HeatmapTrace(this);
        }

        @Override
        protected String getType() {
            return type;
        }
    }
}

