/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;
import tech.tablesaw.plotly.components.Font;

public class HoverLabel
extends Component {
    private final String bgColor;
    private final String borderColor;
    private final Font font;
    private final int nameLength;

    public static HoverLabelBuilder builder() {
        return new HoverLabelBuilder();
    }

    HoverLabel(HoverLabelBuilder builder) {
        this.bgColor = builder.bgColor;
        this.borderColor = builder.borderColor;
        this.font = builder.font;
        this.nameLength = builder.nameLength;
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("hoverLabel_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("bgColor", this.bgColor);
        context.put("borderColor", this.borderColor);
        context.put("nameLength", this.nameLength);
        context.put("font", this.font);
        return context;
    }

    public static class HoverLabelBuilder {
        String bgColor = "";
        String borderColor = "";
        Font font;
        int nameLength = 15;

        public HoverLabel build() {
            return new HoverLabel(this);
        }

        public HoverLabelBuilder nameLength(int nameLength) {
            this.nameLength = nameLength;
            return this;
        }

        public HoverLabelBuilder font(Font font) {
            this.font = font;
            return this;
        }

        public HoverLabelBuilder borderColor(String borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public HoverLabelBuilder bgColor(String bgColor) {
            this.bgColor = bgColor;
            return this;
        }
    }
}

