/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import tech.tablesaw.plotly.components.Figure;
import tech.tablesaw.plotly.components.Page;
import tech.tablesaw.plotly.display.Browser;

public class Plot {
    private static final String DEFAULT_DIV_NAME = "target";
    private static final String DEFAULT_OUTPUT_FILE = "output.html";
    private static final String DEFAULT_OUTPUT_FILE_NAME = "output";
    private static final String DEFAULT_OUTPUT_FOLDER = "testoutput";

    public static void show(Figure figure, String divName, File outputFile) {
        Page page = Page.pageBuilder(figure, divName).build();
        String output = page.asJavascript();
        try {
            try (FileWriter fileWriter = new FileWriter(outputFile);){
                fileWriter.write(output);
            }
            new Browser().browse(outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void show(Figure figure, String divName) {
        Plot.show(figure, divName, Plot.defaultFile());
    }

    public static void show(Figure figure) {
        Plot.show(figure, Plot.randomFile());
    }

    public static void show(Figure figure, File outputFile) {
        Plot.show(figure, DEFAULT_DIV_NAME, outputFile);
    }

    private static File defaultFile() {
        Path path = Paths.get(DEFAULT_OUTPUT_FOLDER, DEFAULT_OUTPUT_FILE);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path.toFile();
    }

    private static File randomFile() {
        Path path = Paths.get(DEFAULT_OUTPUT_FOLDER, Plot.randomizedFileName());
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path.toFile();
    }

    private static String randomizedFileName() {
        return DEFAULT_OUTPUT_FILE_NAME + UUID.randomUUID().toString() + ".html";
    }
}

