/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class PieTrace
extends AbstractTrace {
    private double[] values;
    private Object[] labels;

    private PieTrace(PieBuilder builder) {
        super(builder);
        this.values = builder.values;
        this.labels = builder.labels;
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("pie_trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext(i));
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        context.put("values", Utils.dataAsString(this.values));
        if (this.labels != null) {
            context.put("labels", Utils.dataAsString(this.labels));
        }
        return context;
    }

    public static PieBuilder builder(Object[] labels, double[] values) {
        return new PieBuilder(labels, values);
    }

    public static PieBuilder builder(CategoricalColumn labels, NumberColumn values) {
        return new PieBuilder(TraceBuilder.columnToStringArray((Column)labels), values.asDoubleArray());
    }

    public static class PieBuilder
    extends TraceBuilder {
        private String type = "pie";
        double[] values;
        Object[] labels;

        private PieBuilder(Object[] labels, double[] values) {
            this.labels = labels;
            this.values = values;
        }

        public PieTrace build() {
            return new PieTrace(this);
        }

        @Override
        protected String getType() {
            return this.type;
        }

        @Override
        public PieBuilder showLegend(boolean b) {
            super.showLegend(b);
            return this;
        }
    }
}

