/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.google.common.base.Preconditions;
import java.util.Map;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.components.Font;

public class TickSettings {
    private final TickMode tickMode;
    private final int nTicks;
    private final Object tick0;
    private final Object dTick;
    private final int length;
    private final int width;
    private final String color;
    private final boolean showLabels;
    private final TickPlacement placement;
    private final Font tickFont;
    private final Object[] tickText;
    private final double[] tickValues;
    private final Mirror mirror;
    private final int angle;
    private final String prefix;
    private final String suffix;
    private final boolean autoMargin;
    private final DisplayRules showPrefix;
    private final DisplayRules showSuffix;
    private final DisplayRules showExponent;
    private final ExponentFormat exponentFormat;
    private final boolean separateThousands;

    private TickSettings(TickSettingsBuilder builder) {
        this.tickMode = builder.tickMode;
        this.nTicks = builder.nTicks;
        this.color = builder.tickColor;
        this.length = builder.tickLength;
        this.width = builder.tickWidth;
        this.showLabels = builder.showTickLabels;
        this.tickFont = builder.font;
        this.placement = builder.placement;
        this.tickText = builder.tickText;
        this.tickValues = builder.tickValues;
        this.tick0 = builder.tick0;
        this.dTick = builder.dTick;
        this.showPrefix = builder.showPrefix;
        this.showSuffix = builder.showSuffix;
        this.showExponent = builder.showExponent;
        this.exponentFormat = builder.exponentFormat;
        this.autoMargin = builder.autoMargin;
        this.angle = builder.angle;
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.mirror = builder.mirror;
        this.separateThousands = builder.separateThousands;
    }

    void updateContext(Map<String, Object> context) {
        context.put("showTickLabels", this.showLabels);
        context.put("tickLength", this.length);
        context.put("tickWidth", this.width);
        context.put("tickColor", this.color);
        context.put("tickFont", this.tickFont);
        context.put("ticks", (Object)this.placement);
        if (this.tickText != null) {
            context.put("tickText", Utils.dataAsString(this.tickText));
        }
        if (this.nTicks != 0) {
            context.put("nTicks", this.nTicks);
        }
        if (this.dTick != null) {
            context.put("dTick", this.dTick);
        }
        if (this.tick0 != null) {
            context.put("tick0", this.tick0);
        }
        if (this.showExponent != DisplayRules.ALL) {
            context.put("showExponent", (Object)this.showExponent);
        }
        if (this.exponentFormat != ExponentFormat.B) {
            context.put("exponentFormat", (Object)this.exponentFormat);
        }
        if (this.tickValues != null) {
            context.put("tickValues", Utils.dataAsString(this.tickValues));
        }
        context.put("mirror", (Object)this.mirror);
        context.put("prefix", this.prefix);
        context.put("suffix", this.suffix);
        context.put("showPrefix", (Object)this.showPrefix);
        context.put("showSuffix", (Object)this.showSuffix);
        context.put("angle", this.angle);
        context.put("autoMargin", this.autoMargin);
        context.put("tickMode", (Object)this.tickMode);
        context.put("separateThousands", this.separateThousands);
    }

    public static TickSettingsBuilder builder() {
        return new TickSettingsBuilder();
    }

    public static class TickSettingsBuilder {
        private DisplayRules showExponent = DisplayRules.ALL;
        private ExponentFormat exponentFormat = ExponentFormat.B;
        private Object tick0;
        private Object dTick;
        private TickMode tickMode = TickMode.LINEAR;
        private Object[] tickText;
        private double[] tickValues;
        private int tickLength = 5;
        private int tickWidth = 1;
        private String tickColor = "#444";
        private boolean showTickLabels = true;
        private Font font;
        private TickPlacement placement = TickPlacement.INSIDE;
        private int nTicks = 0;
        private int angle = 0;
        private String prefix;
        private String suffix;
        private boolean autoMargin = true;
        private DisplayRules showPrefix = DisplayRules.ALL;
        private DisplayRules showSuffix = DisplayRules.ALL;
        private Mirror mirror;
        private boolean separateThousands;

        private TickSettingsBuilder() {
        }

        public TickSettingsBuilder arrayTicks(double[] tickValues, String[] tickText) {
            this.tickValues = tickValues;
            this.tickText = tickText;
            return this;
        }

        public TickSettingsBuilder arrayTicks(double[] tickValues) {
            this.tickValues = tickValues;
            return this;
        }

        public TickSettingsBuilder placement(TickPlacement placement) {
            this.placement = placement;
            return this;
        }

        public TickSettingsBuilder nTicks(int nTicks) {
            Preconditions.checkArgument((nTicks >= 0 ? 1 : 0) != 0);
            this.nTicks = nTicks;
            return this;
        }

        public TickSettingsBuilder tickMode(TickMode tickMode) {
            this.tickMode = tickMode;
            return this;
        }

        public TickSettingsBuilder showTickLabels(boolean showTickLabels) {
            this.showTickLabels = showTickLabels;
            return this;
        }

        public TickSettingsBuilder color(String tickColor) {
            this.tickColor = tickColor;
            return this;
        }

        public TickSettingsBuilder font(Font font) {
            this.font = font;
            return this;
        }

        public TickSettingsBuilder width(int tickWidth) {
            Preconditions.checkArgument((tickWidth >= 0 ? 1 : 0) != 0);
            this.tickWidth = tickWidth;
            return this;
        }

        public TickSettingsBuilder length(int tickLength) {
            Preconditions.checkArgument((tickLength >= 0 ? 1 : 0) != 0);
            this.tickLength = tickLength;
            return this;
        }

        public TickSettingsBuilder autoMargin(boolean adjust) {
            this.autoMargin = adjust;
            return this;
        }

        public TickSettingsBuilder separateThousands(boolean separate) {
            this.separateThousands = separate;
            return this;
        }

        public TickSettingsBuilder showSuffix(DisplayRules showSuffix) {
            this.showSuffix = showSuffix;
            return this;
        }

        public TickSettingsBuilder showExponent(DisplayRules showExponent) {
            this.showExponent = showExponent;
            return this;
        }

        public TickSettingsBuilder exponentFormat(ExponentFormat format) {
            this.exponentFormat = format;
            return this;
        }

        public TickSettingsBuilder showPrefix(DisplayRules showPrefix) {
            this.showPrefix = showPrefix;
            return this;
        }

        public TickSettingsBuilder mirror(Mirror mirror) {
            this.mirror = mirror;
            return this;
        }

        public TickSettingsBuilder angle(int angle) {
            this.angle = angle;
            return this;
        }

        public TickSettingsBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public TickSettingsBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public TickSettingsBuilder tick0(Object tick0) {
            this.tick0 = tick0;
            return this;
        }

        public TickSettingsBuilder dTick(Object dTick) {
            this.dTick = dTick;
            return this;
        }

        public TickSettings build() {
            return new TickSettings(this);
        }
    }

    public static enum ExponentFormat {
        NONE("none"),
        e("e"),
        E("E"),
        POWER("power"),
        SI("SI"),
        B("B");

        private String value;

        private ExponentFormat(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Mirror {
        TRUE("true"),
        FALSE("false"),
        TICKS("ticks"),
        ALL("all"),
        ALL_TICKS("allticks");

        private String value;

        private Mirror(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum DisplayRules {
        ALL("outside"),
        FIRST("first"),
        LAST("last"),
        NONE("none");

        private String value;

        private DisplayRules(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum TickPlacement {
        OUTSIDE("outside"),
        INSIDE("inside"),
        NONE("");

        private String value;

        private TickPlacement(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum TickMode {
        AUTO("auto"),
        LINEAR("linear"),
        ARRAY("array");

        private String value;

        private TickMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

