/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.google.common.base.Preconditions;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Component;

public class Font
extends Component {
    private Family fontFamily;
    private int size;
    private String color;

    public static FontBuilder builder() {
        return new FontBuilder();
    }

    private Font(FontBuilder builder) {
        this.color = builder.color;
        this.fontFamily = builder.fontFamily;
        this.size = builder.size;
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("font_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("size", this.size);
        context.put("family", (Object)this.fontFamily);
        context.put("color", this.color);
        return context;
    }

    public static class FontBuilder {
        Family fontFamily = Family.OPEN_SANS;
        int size = 12;
        String color = "#444";

        private FontBuilder() {
        }

        public FontBuilder size(int size) {
            Preconditions.checkArgument((size >= 1 ? 1 : 0) != 0);
            this.size = size;
            return this;
        }

        public FontBuilder color(String color) {
            this.color = color;
            return this;
        }

        public FontBuilder family(Family family) {
            this.fontFamily = family;
            return this;
        }

        public Font build() {
            return new Font(this);
        }
    }

    public static enum Family {
        OPEN_SANS("Open Sans"),
        VERDANA("verdana"),
        ARIAL("arial"),
        SANS_SERIF("sans-serif");

        private final String value;

        private Family(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

