/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.jsonl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.Writer;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.RuntimeIOException;
import tech.tablesaw.io.WriterRegistry;
import tech.tablesaw.io.jsonl.JsonlWriteOptions;

public class JsonlWriter
implements DataWriter<JsonlWriteOptions> {
    private static final JsonlWriter INSTANCE = new JsonlWriter();
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    public static void register(WriterRegistry registry) {
        registry.registerExtension("jsonl", (DataWriter)INSTANCE);
        registry.registerOptions(JsonlWriteOptions.class, (DataWriter)INSTANCE);
    }

    public void write(Table table, JsonlWriteOptions options) {
        try (Writer writer = options.destination().createWriter();){
            for (int r = 0; r < table.rowCount(); ++r) {
                ObjectNode row = mapper.createObjectNode();
                for (int c = 0; c < table.columnCount(); ++c) {
                    row.set(table.column(c).name(), (JsonNode)mapper.convertValue(table.get(r, c), JsonNode.class));
                }
                String str = mapper.writeValueAsString((Object)row);
                writer.write(str);
                if (r >= table.rowCount() - 1) continue;
                writer.write("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void write(Table table, Destination dest) {
        this.write(table, JsonlWriteOptions.builder(dest).build());
    }

    static {
        JsonlWriter.register(Table.defaultWriterRegistry);
    }
}

