/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.jsonl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.wnameless.json.flattener.JsonFlattener;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.RuntimeIOException;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.TableBuildingUtils;
import tech.tablesaw.io.jsonl.JsonlReadOptions;

public class JsonlReader
implements DataReader<JsonlReadOptions> {
    private static final JsonlReader INSTANCE = new JsonlReader();
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void register(ReaderRegistry registry) {
        registry.registerExtension("jsonl", (DataReader)INSTANCE);
        registry.registerMimeType("application/json-lines", (DataReader)INSTANCE);
        registry.registerMimeType("application/jsonl", (DataReader)INSTANCE);
        registry.registerMimeType("application/jsonlines", (DataReader)INSTANCE);
        registry.registerMimeType("application/ldjson", (DataReader)INSTANCE);
        registry.registerMimeType("application/ndjson", (DataReader)INSTANCE);
        registry.registerMimeType("application/x-json-lines", (DataReader)INSTANCE);
        registry.registerMimeType("application/x-jsonl", (DataReader)INSTANCE);
        registry.registerMimeType("application/x-jsonlines", (DataReader)INSTANCE);
        registry.registerMimeType("application/x-ldjson", (DataReader)INSTANCE);
        registry.registerMimeType("application/x-ndjson", (DataReader)INSTANCE);
        registry.registerMimeType("text/json-lines", (DataReader)INSTANCE);
        registry.registerMimeType("text/jsonl", (DataReader)INSTANCE);
        registry.registerMimeType("text/jsonlines", (DataReader)INSTANCE);
        registry.registerMimeType("text/ldjson", (DataReader)INSTANCE);
        registry.registerMimeType("text/ndjson", (DataReader)INSTANCE);
        registry.registerMimeType("text/x-json-lines", (DataReader)INSTANCE);
        registry.registerMimeType("text/x-jsonl", (DataReader)INSTANCE);
        registry.registerMimeType("text/x-jsonlines", (DataReader)INSTANCE);
        registry.registerMimeType("text/x-ldjson", (DataReader)INSTANCE);
        registry.registerMimeType("text/x-ndjson", (DataReader)INSTANCE);
        registry.registerOptions(JsonlReadOptions.class, (DataReader)INSTANCE);
    }

    public Table read(JsonlReadOptions options) {
        ObjectReader stream = mapper.readerFor(JsonNode.class);
        try {
            Reader reader = options.source().createReader(null);
            JsonParser parser = stream.createParser(reader);
            MappingIterator iter = stream.readValues(parser);
            return this.convertObjects((Iterator<JsonNode>)iter, options);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private Table convertObjects(Iterator<JsonNode> iter, ReadOptions options) {
        StringBuilder result = new StringBuilder("[");
        boolean first = true;
        while (iter.hasNext()) {
            JsonNode rowObj = iter.next();
            String flattenedRow = null;
            try {
                flattenedRow = JsonFlattener.flatten((String)mapper.writeValueAsString((Object)rowObj));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeIOException((IOException)((Object)e));
            }
            if (!first) {
                result.append(",");
            }
            first = false;
            result.append(flattenedRow);
        }
        String flattenedJsonString = result.append("]").toString();
        JsonNode flattenedJsonObj = null;
        try {
            flattenedJsonObj = mapper.readTree(flattenedJsonString);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeIOException((IOException)((Object)e));
        }
        LinkedHashSet<String> colNames = new LinkedHashSet<String>();
        for (JsonNode row : flattenedJsonObj) {
            Iterator fieldNames = row.fieldNames();
            while (fieldNames.hasNext()) {
                colNames.add((String)fieldNames.next());
            }
        }
        ArrayList columnNames = new ArrayList(colNames);
        ArrayList<String[]> dataRows = new ArrayList<String[]>();
        for (JsonNode node : flattenedJsonObj) {
            String[] arr = new String[columnNames.size()];
            for (int i = 0; i < columnNames.size(); ++i) {
                arr[i] = node.has((String)columnNames.get(i)) ? node.get((String)columnNames.get(i)).asText() : null;
            }
            dataRows.add(arr);
        }
        return TableBuildingUtils.build(columnNames, dataRows, (ReadOptions)options);
    }

    public Table read(Source source) {
        return this.read(JsonlReadOptions.builder(source).build());
    }

    static {
        JsonlReader.register(Table.defaultReaderRegistry);
    }
}

