/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Writer;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.WriterRegistry;
import tech.tablesaw.io.json.JsonWriteOptions;

public class JsonWriter
implements DataWriter<JsonWriteOptions> {
    private static final JsonWriter INSTANCE = new JsonWriter();
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void register(WriterRegistry registry) {
        registry.registerExtension("json", (DataWriter)INSTANCE);
        registry.registerOptions(JsonWriteOptions.class, (DataWriter)INSTANCE);
    }

    public void write(Table table, JsonWriteOptions options) throws IOException {
        int r;
        ArrayNode output = mapper.createArrayNode();
        if (options.asObjects()) {
            for (r = 0; r < table.rowCount(); ++r) {
                ObjectNode row = mapper.createObjectNode();
                for (int c = 0; c < table.columnCount(); ++c) {
                    row.set(table.column(c).name(), (JsonNode)mapper.convertValue(table.get(r, c), JsonNode.class));
                }
                output.add((JsonNode)row);
            }
        } else {
            if (options.header()) {
                ArrayNode row = mapper.createArrayNode();
                for (int c = 0; c < table.columnCount(); ++c) {
                    row.add((JsonNode)mapper.convertValue((Object)table.column(c).name(), JsonNode.class));
                }
                output.add((JsonNode)row);
            }
            for (r = 0; r < table.rowCount(); ++r) {
                ArrayNode row = mapper.createArrayNode();
                for (int c = 0; c < table.columnCount(); ++c) {
                    row.add((JsonNode)mapper.convertValue(table.get(r, c), JsonNode.class));
                }
                output.add((JsonNode)row);
            }
        }
        String str = mapper.writeValueAsString((Object)output);
        Writer writer = options.destination().createWriter();
        writer.write(str);
        writer.flush();
    }

    public void write(Table table, Destination dest) throws IOException {
        this.write(table, JsonWriteOptions.builder(dest).build());
    }

    static {
        JsonWriter.register(Table.defaultWriterRegistry);
    }
}

