/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.json;

import java.io.Writer;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.WriteOptions;

public class JsonWriteOptions
extends WriteOptions {
    private final boolean asObjects;
    private final boolean header;

    private JsonWriteOptions(Builder builder) {
        super((WriteOptions.Builder)builder);
        this.asObjects = builder.asObjects;
        this.header = builder.header;
    }

    public boolean asObjects() {
        return this.asObjects;
    }

    public boolean header() {
        return this.header;
    }

    public static Builder builder(Writer writer) {
        return new Builder(new Destination(writer));
    }

    public static Builder builder(Destination destination) {
        return new Builder(destination);
    }

    protected static class Builder
    extends WriteOptions.Builder {
        private boolean asObjects = true;
        private boolean header = false;

        public Builder(Destination destination) {
            super(destination);
        }

        public Builder asObjects(boolean asObjects) {
            this.asObjects = asObjects;
            return this;
        }

        public Builder header(boolean header) {
            this.header = header;
            return this;
        }

        public JsonWriteOptions build() {
            return new JsonWriteOptions(this);
        }
    }
}

