/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.WriterRegistry;
import tech.tablesaw.io.html.HtmlWriteOptions;

public class HtmlWriter
implements DataWriter<HtmlWriteOptions> {
    private static final HtmlWriter INSTANCE = new HtmlWriter();

    public static void register(WriterRegistry registry) {
        registry.registerExtension("html", (DataWriter)INSTANCE);
        registry.registerOptions(HtmlWriteOptions.class, (DataWriter)INSTANCE);
    }

    public void write(Table table, HtmlWriteOptions options) throws IOException {
        HtmlWriteOptions.ElementCreator elements = options.elementCreator();
        Element html = elements.create("table");
        html.appendChild((Node)HtmlWriter.header(table.columns(), elements));
        Element tbody = elements.create("tbody");
        html.appendChild((Node)tbody);
        for (int row = 0; row < table.rowCount(); ++row) {
            tbody.appendChild((Node)HtmlWriter.row(row, table, elements, options));
        }
        Writer writer = options.destination().createWriter();
        writer.write(html.toString());
        writer.flush();
    }

    private static Element row(int row, Table table, HtmlWriteOptions.ElementCreator elements, HtmlWriteOptions options) {
        Element tr = elements.create("tr", null, row);
        for (Column col : table.columns()) {
            if (options.escapeText()) {
                tr.appendChild((Node)elements.create("td", col, row).appendText(String.valueOf(col.getString(row))));
                continue;
            }
            tr.appendChild((Node)elements.create("td", col, row).appendChild((Node)new DataNode(String.valueOf(col.getString(row)))));
        }
        return tr;
    }

    private static Element header(List<Column<?>> cols, HtmlWriteOptions.ElementCreator elements) {
        Element thead = elements.create("thead");
        Element tr = elements.create("tr");
        thead.appendChild((Node)tr);
        for (Column<?> col : cols) {
            tr.appendChild((Node)elements.create("th", col, null).appendText(col.name()));
        }
        return thead;
    }

    public void write(Table table, Destination dest) throws IOException {
        this.write(table, HtmlWriteOptions.builder(dest).build());
    }

    static {
        HtmlWriter.register(Table.defaultWriterRegistry);
    }
}

