/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.TableBuildingUtils;
import tech.tablesaw.io.html.HtmlReadOptions;

public class HtmlReader
implements DataReader<HtmlReadOptions> {
    private static final HtmlReader INSTANCE = new HtmlReader();

    public static void register(ReaderRegistry registry) {
        registry.registerExtension("html", (DataReader)INSTANCE);
        registry.registerMimeType("text/html", (DataReader)INSTANCE);
        registry.registerOptions(HtmlReadOptions.class, (DataReader)INSTANCE);
    }

    public Table read(HtmlReadOptions options) throws IOException {
        InputStream inputStream = options.source().inputStream();
        Document doc = inputStream != null ? Jsoup.parse((InputStream)inputStream, null, (String)"") : Parser.htmlParser().parseInput(options.source().createReader(null), "");
        Elements tables = doc.select("table");
        if (tables.size() != 1) {
            throw new IllegalStateException("Reading html to table currently works if there is exactly 1 html table on the page.  The URL you passed has " + tables.size() + ". You may file a feature request with the URL if you'd like your pagae to be supported");
        }
        Element htmlTable = (Element)tables.get(0);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (Element row : htmlTable.select("tr")) {
            Elements headerCells = row.getElementsByTag("th");
            Elements cells = row.getElementsByTag("td");
            String[] nextLine = (String[])Stream.concat(headerCells.stream(), cells.stream()).map(Element::text).toArray(String[]::new);
            rows.add(nextLine);
        }
        Table table = Table.create((String)options.tableName());
        if (rows.size() == 0) {
            return table;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        if (options.header()) {
            String[] headerRow = (String[])rows.remove(0);
            for (int i = 0; i < headerRow.length; ++i) {
                columnNames.add(headerRow[i]);
            }
        } else {
            for (int i = 0; i < ((String[])rows.get(0)).length; ++i) {
                columnNames.add("C" + i);
            }
        }
        return TableBuildingUtils.build(columnNames, rows, (ReadOptions)options);
    }

    public Table read(Source source) throws IOException {
        return this.read(HtmlReadOptions.builder(source).build());
    }

    static {
        HtmlReader.register(Table.defaultReaderRegistry);
    }
}

