/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.ParsingUtils;

public class HtmlTableWriter {
    public String write(Table table) {
        StringBuilder builder = new StringBuilder();
        builder.append(HtmlTableWriter.header(table.columnNames()));
        builder.append("<tbody>").append(System.lineSeparator());
        for (int row = 0; row < table.rowCount(); ++row) {
            builder.append(HtmlTableWriter.row(row, table));
        }
        builder.append("</tbody>");
        return builder.toString();
    }

    public void write(Table table, OutputStream outputStream) {
        try (PrintWriter p = new PrintWriter(outputStream);){
            p.println(this.write(table));
        }
    }

    private static String row(int row, Table table) {
        StringBuilder builder = new StringBuilder().append("<tr>");
        for (Column col : table.columns()) {
            builder.append("<td>").append(String.valueOf(col.getString(row))).append("</td>");
        }
        builder.append("</tr>").append(System.lineSeparator());
        return builder.toString();
    }

    private static String header(List<String> columnNames) {
        StringBuilder builder = new StringBuilder().append("<thead>").append(System.lineSeparator()).append("<tr>");
        for (String name : columnNames) {
            builder.append("<th>").append(ParsingUtils.splitCamelCase((String)ParsingUtils.splitOnUnderscore((String)name))).append("</th>");
        }
        builder.append("</tr>").append(System.lineSeparator()).append("</thead>").append(System.lineSeparator());
        return builder.toString();
    }
}

