/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.xlsx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.Source;

public class XlsxReadOptions
extends ReadOptions {
    protected Integer sheetIndex;

    protected XlsxReadOptions(Builder builder) {
        super((ReadOptions.Builder)builder);
        this.sheetIndex = builder.sheetIndex;
    }

    public static Builder builder(Source source) {
        return new Builder(source);
    }

    public static Builder builder(File file) {
        return new Builder(file).tableName(file.getName());
    }

    public static Builder builder(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builder(URL url) throws IOException {
        return new Builder(url);
    }

    public static Builder builderFromFile(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builderFromUrl(String url) throws IOException {
        return new Builder(new URL(url));
    }

    public Integer sheetIndex() {
        return this.sheetIndex;
    }

    public static class Builder
    extends ReadOptions.Builder {
        protected Integer sheetIndex;

        protected Builder(Source source) {
            super(source);
        }

        protected Builder(URL url) throws IOException {
            super(url);
        }

        public Builder(File file) {
            super(file);
        }

        public Builder(InputStream stream) {
            super(stream);
        }

        public Builder(Reader reader) {
            super(reader);
        }

        public XlsxReadOptions build() {
            return new XlsxReadOptions(this);
        }

        public Builder header(boolean header) {
            super.header(header);
            return this;
        }

        public Builder tableName(String tableName) {
            super.tableName(tableName);
            return this;
        }

        public Builder sample(boolean sample) {
            super.sample(sample);
            return this;
        }

        @Deprecated
        public Builder dateFormat(String dateFormat) {
            super.dateFormat(dateFormat);
            return this;
        }

        @Deprecated
        public Builder timeFormat(String timeFormat) {
            super.timeFormat(timeFormat);
            return this;
        }

        @Deprecated
        public Builder dateTimeFormat(String dateTimeFormat) {
            super.dateTimeFormat(dateTimeFormat);
            return this;
        }

        public Builder dateFormat(DateTimeFormatter dateFormat) {
            super.dateFormat(dateFormat);
            return this;
        }

        public Builder timeFormat(DateTimeFormatter timeFormat) {
            super.timeFormat(timeFormat);
            return this;
        }

        public Builder dateTimeFormat(DateTimeFormatter dateTimeFormat) {
            super.dateTimeFormat(dateTimeFormat);
            return this;
        }

        public Builder locale(Locale locale) {
            super.locale(locale);
            return this;
        }

        public Builder missingValueIndicator(String missingValueIndicator) {
            super.missingValueIndicator(missingValueIndicator);
            return this;
        }

        public Builder minimizeColumnSizes() {
            super.minimizeColumnSizes();
            return this;
        }

        public Builder sheetIndex(int sheetIndex) {
            this.sheetIndex = sheetIndex;
            return this;
        }
    }
}

