/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.xlsx;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.xlsx.XlsxReadOptions;

@Immutable
public class XlsxReader
implements DataReader<XlsxReadOptions> {
    private static final XlsxReader INSTANCE = new XlsxReader();

    public static void register(ReaderRegistry registry) {
        registry.registerExtension("xlsx", (DataReader)INSTANCE);
        registry.registerMimeType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (DataReader)INSTANCE);
        registry.registerOptions(XlsxReadOptions.class, (DataReader)INSTANCE);
    }

    public Table read(XlsxReadOptions options) throws IOException {
        List<Table> tables = this.readMultiple(options);
        if (tables.isEmpty()) {
            throw new IllegalArgumentException("No tables found.");
        }
        return tables.get(0);
    }

    /*
     * Loose catch block
     */
    public List<Table> readMultiple(XlsxReadOptions options) throws IOException {
        byte[] bytes = null;
        InputStream input = this.getInputStream(options, bytes);
        ArrayList<Table> tables = new ArrayList<Table>();
        try {
            try (XSSFWorkbook workbook = new XSSFWorkbook(input);){
                for (Sheet sheet : workbook) {
                    TableRange tableArea = this.findTableArea(sheet);
                    if (tableArea == null) continue;
                    Table table = this.createTable(sheet, tableArea, options);
                    tables.add(table);
                }
                ArrayList<Table> arrayList = tables;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (options.source().reader() == null) {
                input.close();
            }
        }
    }

    private Boolean isBlank(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                if (cell.getRichStringCellValue().length() <= 0) break;
                return false;
            }
            case NUMERIC: {
                if (!(DateUtil.isCellDateFormatted((Cell)cell) ? cell.getDateCellValue() != null : cell.getNumericCellValue() != 0.0)) break;
                return false;
            }
            case BOOLEAN: {
                if (!cell.getBooleanCellValue()) break;
                return false;
            }
            case BLANK: {
                return true;
            }
        }
        return null;
    }

    private ColumnType getColumnType(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                return ColumnType.STRING;
            }
            case NUMERIC: {
                return DateUtil.isCellDateFormatted((Cell)cell) ? ColumnType.LOCAL_DATE_TIME : ColumnType.INTEGER;
            }
            case BOOLEAN: {
                return ColumnType.BOOLEAN;
            }
        }
        return null;
    }

    private TableRange findTableArea(Sheet sheet) {
        int row1 = -1;
        int row2 = -1;
        TableRange lastRowArea = null;
        for (Row row : sheet) {
            TableRange rowArea = this.findRowArea(row);
            if (lastRowArea == null && rowArea != null) {
                if (row1 >= 0) continue;
                lastRowArea = rowArea;
                row2 = row1 = row.getRowNum();
                continue;
            }
            if (lastRowArea != null && rowArea == null) {
                if (row2 > row1) break;
                row1 = -1;
                continue;
            }
            if (lastRowArea == null && rowArea == null) {
                row1 = -1;
                continue;
            }
            if (rowArea.startColumn < lastRowArea.startColumn || rowArea.endColumn > lastRowArea.endColumn) {
                lastRowArea = null;
                row2 = -1;
                continue;
            }
            row2 = row.getRowNum();
        }
        return row1 >= 0 && lastRowArea != null ? new TableRange(row1, row2, lastRowArea.startColumn, lastRowArea.endColumn) : null;
    }

    private TableRange findRowArea(Row row) {
        int col1 = -1;
        int col2 = -1;
        for (Cell cell : row) {
            Boolean blank = this.isBlank(cell);
            if (col1 < 0 && Boolean.FALSE.equals(blank)) {
                col2 = col1 = cell.getColumnIndex();
                continue;
            }
            if (col1 < 0 || col2 < col1) continue;
            if (Boolean.FALSE.equals(blank)) {
                col2 = cell.getColumnIndex();
                continue;
            }
            if (!Boolean.TRUE.equals(blank)) continue;
            break;
        }
        return col1 >= 0 && col2 >= col1 ? new TableRange(0, 0, col1, col2) : null;
    }

    private InputStream getInputStream(XlsxReadOptions options, byte[] bytes) throws FileNotFoundException {
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        if (options.source().inputStream() != null) {
            return options.source().inputStream();
        }
        return new FileInputStream(options.source().file());
    }

    private Table createTable(Sheet sheet, TableRange tableArea, XlsxReadOptions options) {
        Cell cell;
        Row row = sheet.getRow(tableArea.startRow);
        ArrayList<String> headerNames = new ArrayList<String>();
        Iterator iterator = row.iterator();
        while (iterator.hasNext() && (cell = (Cell)iterator.next()).getCellType() == CellType.STRING) {
            headerNames.add(cell.getRichStringCellValue().getString());
        }
        if (headerNames.size() == tableArea.endColumn - tableArea.startColumn + 1) {
            tableArea.startRow++;
        } else {
            headerNames.clear();
            for (int col = tableArea.startColumn; col <= tableArea.endColumn; ++col) {
                headerNames.add("col" + col);
            }
        }
        Table table = Table.create((String)options.tableName());
        ArrayList<Object> columns = new ArrayList<Object>(Collections.nCopies(headerNames.size(), null));
        for (int rowNum = tableArea.startRow; rowNum <= tableArea.endRow; ++rowNum) {
            row = sheet.getRow(rowNum);
            for (int colNum = 0; colNum < headerNames.size(); ++colNum) {
                Cell cell2 = row.getCell(colNum + tableArea.startColumn, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                Column<?> column = (Column<?>)columns.get(colNum);
                if (cell2 != null) {
                    Column<?> altColumn;
                    if (column == null) {
                        column = this.createColumn((String)headerNames.get(colNum), cell2);
                        columns.set(colNum, column);
                        while (column.size() < rowNum - tableArea.startRow) {
                            column.appendMissing();
                        }
                    }
                    if ((altColumn = this.appendValue(column, cell2)) != null && altColumn != column) {
                        column = altColumn;
                        columns.set(colNum, column);
                    }
                }
                if (column == null) continue;
                while (column.size() <= rowNum - tableArea.startRow) {
                    column.appendMissing();
                }
            }
        }
        columns.removeAll(Collections.singleton(null));
        table.addColumns(columns.toArray(new Column[columns.size()]));
        return table;
    }

    private Column<?> appendValue(Column<?> column, Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                column.appendCell(cell.getRichStringCellValue().getString());
                return null;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    LocalDateTime localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                    column.appendCell(localDate.toString());
                    return null;
                }
                double num = cell.getNumericCellValue();
                if (column.type() == ColumnType.INTEGER) {
                    Column<?> intColumn = column;
                    if ((double)((int)num) == num) {
                        intColumn.append((Object)((int)num));
                        return null;
                    }
                    if ((double)((long)num) == num) {
                        LongColumn altColumn = LongColumn.create((String)column.name(), (int)column.size());
                        altColumn = intColumn.mapInto(s -> (long)s, (Column)altColumn);
                        altColumn.append((Object)((long)num));
                        return altColumn;
                    }
                    DoubleColumn altColumn = DoubleColumn.create((String)column.name(), (int)column.size());
                    altColumn = intColumn.mapInto(s -> (double)s, (Column)altColumn);
                    altColumn.append((Object)num);
                    return altColumn;
                }
                if (column.type() == ColumnType.LONG) {
                    Column<?> longColumn = column;
                    if ((double)((long)num) == num) {
                        longColumn.append((Object)((long)num));
                        return null;
                    }
                    DoubleColumn altColumn = DoubleColumn.create((String)column.name(), (int)column.size());
                    altColumn = longColumn.mapInto(s -> (double)s, (Column)altColumn);
                    altColumn.append((Object)num);
                    return altColumn;
                }
                if (column.type() != ColumnType.DOUBLE) break;
                Column<?> doubleColumn = column;
                doubleColumn.append((Object)num);
                return null;
            }
            case BOOLEAN: {
                if (column.type() != ColumnType.BOOLEAN) break;
                Column<?> booleanColumn = column;
                booleanColumn.append((Object)cell.getBooleanCellValue());
                return null;
            }
        }
        return null;
    }

    private Column<?> createColumn(String name, Cell cell) {
        ColumnType columnType = this.getColumnType(cell);
        if (columnType == null) {
            columnType = ColumnType.STRING;
        }
        Column column = columnType.create(name);
        return column;
    }

    public Table read(Source source) throws IOException {
        return this.read(XlsxReadOptions.builder(source).build());
    }

    static {
        XlsxReader.register(Table.defaultReaderRegistry);
    }

    private static class TableRange {
        private int startRow;
        private int endRow;
        private int startColumn;
        private int endColumn;

        TableRange(int startRow, int endRow, int startColumn, int endColumn) {
            this.startRow = startRow;
            this.endRow = endRow;
            this.startColumn = startColumn;
            this.endColumn = endColumn;
        }
    }
}

