/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.xlsx;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import tech.tablesaw.io.ReadOptions;

public class XlsxReadOptions
extends ReadOptions {
    protected XlsxReadOptions(Builder builder) {
        super((ReadOptions.Builder)builder);
    }

    public static Builder builder(File file) {
        return new Builder(file);
    }

    public static Builder builder(String fileName) {
        return new Builder(new File(fileName));
    }

    public static class Builder
    extends ReadOptions.Builder {
        public Builder(File file) {
            super(file);
        }

        public Builder(InputStream stream) {
            super(stream);
        }

        public Builder(Reader reader) {
            super(reader);
        }

        public XlsxReadOptions build() {
            return new XlsxReadOptions(this);
        }

        public Builder header(boolean header) {
            super.header(header);
            return this;
        }

        public Builder tableName(String tableName) {
            super.tableName(tableName);
            return this;
        }

        public Builder sample(boolean sample) {
            super.sample(sample);
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            super.dateFormat(dateFormat);
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            super.timeFormat(timeFormat);
            return this;
        }

        public Builder dateTimeFormat(String dateTimeFormat) {
            super.dateTimeFormat(dateTimeFormat);
            return this;
        }

        public Builder locale(Locale locale) {
            super.locale(locale);
            return this;
        }

        public Builder missingValueIndicator(String missingValueIndicator) {
            super.missingValueIndicator(missingValueIndicator);
            return this;
        }

        public Builder minimizeColumnSizes(boolean minimizeColumnSizes) {
            super.minimizeColumnSizes(minimizeColumnSizes);
            return this;
        }
    }
}

