/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.io.UnicodeBOMInputStream;
import tech.tablesaw.io.csv.AddCellToColumnException;
import tech.tablesaw.io.csv.CsvReadOptions;

@Immutable
public class CsvReader {
    private static Predicate<String> isBoolean = s -> TypeUtils.TRUE_STRINGS_FOR_DETECTION.contains(s) || TypeUtils.FALSE_STRINGS_FOR_DETECTION.contains(s);
    private static Predicate<String> isLong = new Predicate<String>(){

        @Override
        public boolean test(@Nullable String s) {
            try {
                Long.parseLong(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static Predicate<String> isInteger = s -> {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private static Predicate<String> isFloat = s -> {
        try {
            Float.parseFloat(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private static Predicate<String> isDouble = s -> {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private static Predicate<String> isShort = s -> {
        try {
            Short.parseShort(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private static Predicate<String> isLocalDate = s -> {
        try {
            LocalDate.parse(s, TypeUtils.DATE_FORMATTER);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    };
    private static Predicate<String> isLocalTime = s -> {
        try {
            LocalTime.parse(s, TypeUtils.TIME_DETECTION_FORMATTER);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    };
    private static Predicate<String> isLocalDateTime = s -> {
        try {
            LocalDateTime.parse(s, TypeUtils.DATE_TIME_FORMATTER);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    };

    private CsvReader() {
    }

    @Deprecated
    public static Table read(ColumnType[] types, String ... fileNames) throws IOException {
        if (fileNames.length == 1) {
            return CsvReader.read(types, true, ',', fileNames[0]);
        }
        Table table = CsvReader.read(types, true, ',', fileNames[0]);
        for (int i = 1; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            table.append(CsvReader.read(types, true, ',', fileName));
        }
        return table;
    }

    @Deprecated
    public static Table read(ColumnType[] types, boolean header, char columnSeparator, String fileName) throws IOException {
        FileInputStream stream = new FileInputStream(new File(fileName));
        return CsvReader.read((InputStream)stream, fileName, types, header, columnSeparator);
    }

    @Deprecated
    public static Table read(File file, boolean header, char delimiter) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        return CsvReader.read(stream, file.getName(), true, delimiter);
    }

    @Deprecated
    public static Table read(InputStream stream, String tableName, boolean header, char delimiter) throws IOException {
        return CsvReader.read(stream, tableName, true, delimiter, false);
    }

    public static Table read(File file, String tableName, boolean header, char delimiter, boolean skipSampling) throws IOException {
        ColumnType[] columnTypes = CsvReader.detectColumnTypes(new FileInputStream(file), header, delimiter, skipSampling);
        Table table = CsvReader.read((InputStream)new FileInputStream(file), tableName, columnTypes, true, delimiter);
        return table;
    }

    @Deprecated
    public static Table read(InputStream stream, String tableName, boolean header, char delimiter, boolean skipSampling) throws IOException {
        byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
        ColumnType[] columnTypes = CsvReader.detectColumnTypes(new ByteArrayInputStream(bytes), header, delimiter, skipSampling);
        Table table = CsvReader.read((InputStream)new ByteArrayInputStream(bytes), tableName, columnTypes, true, delimiter);
        return table;
    }

    @Deprecated
    public static Table read(File file, String tableName, ColumnType[] types, boolean header, char columnSeparator) throws IOException {
        return CsvReader.read((InputStream)new FileInputStream(file), tableName, types, header, columnSeparator);
    }

    @Deprecated
    public static Table read(InputStream stream, String tableName, ColumnType[] types, boolean header, char columnSeparator) throws IOException {
        return CsvReader.read(CsvReadOptions.builder(stream, tableName).columnTypes(types).header(header).separator(columnSeparator).build());
    }

    public static Table read(CsvReadOptions options) throws IOException {
        Table table;
        byte[] bytes;
        ColumnType[] types = options.columnTypes();
        byte[] byArray = bytes = options.stream() != null ? ByteStreams.toByteArray((InputStream)options.stream()) : null;
        if (types == null) {
            InputStream detectTypesStream = options.stream() != null ? new ByteArrayInputStream(bytes) : new FileInputStream(options.file());
            types = CsvReader.detectColumnTypes(detectTypesStream, options.header(), options.separator(), options.sample());
        }
        InputStream stream = options.stream() != null ? new ByteArrayInputStream(bytes) : new FileInputStream(options.file());
        UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(stream);
        ubis.skipBOM();
        CSVParser csvParser = new CSVParserBuilder().withSeparator(options.separator()).build();
        try (CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(ubis)).withCSVParser((ICSVParser)csvParser).build();){
            long rowNumber;
            Object[] columnNames;
            ArrayList headerRow;
            Object[] nextLine;
            if (options.header()) {
                nextLine = reader.readNext();
                headerRow = Lists.newArrayList((Object[])nextLine);
                columnNames = CsvReader.selectColumnNames(headerRow, types);
            } else {
                columnNames = CsvReader.makeColumnNames(types);
                headerRow = Lists.newArrayList((Object[])columnNames);
            }
            table = Table.create(options.tableName());
            for (int x = 0; x < types.length; ++x) {
                if (types[x] == ColumnType.SKIP) continue;
                String columnName = (String)headerRow.get(x);
                if (Strings.isNullOrEmpty((String)columnName)) {
                    columnName = "Column " + table.columnCount();
                }
                Column newColumn = TypeUtils.newColumn(columnName.trim(), types[x]);
                table.addColumn(newColumn);
            }
            int[] columnIndexes = new int[columnNames.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = headerRow.indexOf(columnNames[i]);
            }
            long l = rowNumber = options.header() ? 1L : 0L;
            while ((nextLine = reader.readNext()) != null) {
                int cellIndex = 0;
                for (int columnIndex : columnIndexes) {
                    Column column = table.column(cellIndex);
                    try {
                        column.appendCell((String)nextLine[columnIndex]);
                    }
                    catch (Exception e) {
                        throw new AddCellToColumnException(e, columnIndex, rowNumber, (String[])columnNames, (String[])nextLine);
                    }
                    ++cellIndex;
                }
                ++rowNumber;
            }
        }
        return table;
    }

    public static Table headerOnly(ColumnType[] types, boolean header, char columnSeparator, File file) throws IOException {
        Table table;
        FileInputStream fis = new FileInputStream(file);
        UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(fis);
        ubis.skipBOM();
        InputStreamReader reader = new InputStreamReader(ubis);
        BufferedReader streamReader = new BufferedReader(reader);
        CSVParser csvParser = new CSVParserBuilder().withSeparator(columnSeparator).build();
        try (CSVReader csvReader = new CSVReaderBuilder((Reader)streamReader).withCSVParser((ICSVParser)csvParser).build();){
            Object[] columnNames;
            ArrayList headerRow;
            if (header) {
                Object[] nextLine = csvReader.readNext();
                headerRow = Lists.newArrayList((Object[])nextLine);
                columnNames = CsvReader.selectColumnNames(headerRow, types);
            } else {
                columnNames = CsvReader.makeColumnNames(types);
                headerRow = Lists.newArrayList((Object[])columnNames);
            }
            table = Table.create(file.getName());
            for (int x = 0; x < types.length; ++x) {
                if (types[x] == ColumnType.SKIP) continue;
                Column newColumn = TypeUtils.newColumn(((String)headerRow.get(x)).trim(), types[x]);
                table.addColumn(newColumn);
            }
            int[] columnIndexes = new int[columnNames.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = headerRow.indexOf(columnNames[i]);
            }
        }
        return table;
    }

    private static Table detectedColumnTypes(String csvFileName, boolean header, char delimiter) throws IOException {
        File file = new File(csvFileName);
        FileInputStream stream = new FileInputStream(file);
        ColumnType[] types = CsvReader.detectColumnTypes(stream, header, delimiter, false);
        Table t = CsvReader.headerOnly(types, header, delimiter, file);
        return t.structure();
    }

    public static String printColumnTypes(String csvFileName, boolean header, char delimiter) throws IOException {
        Table structure = CsvReader.detectedColumnTypes(csvFileName, header, delimiter);
        StringBuilder buf = new StringBuilder();
        buf.append("ColumnType[] columnTypes = {");
        buf.append('\n');
        Column typeCol = structure.column("Column Type");
        Column indxCol = structure.column("Index");
        Column nameCol = structure.column("Column Name");
        int typeColIndex = structure.columnIndex(typeCol);
        int indxColIndex = structure.columnIndex(indxCol);
        int nameColIndex = structure.columnIndex(nameCol);
        int typeColWidth = typeCol.columnWidth();
        int indxColWidth = indxCol.columnWidth();
        int nameColWidth = nameCol.columnWidth();
        for (int r = 0; r < structure.rowCount(); ++r) {
            String cell = StringUtils.rightPad((String)(structure.get(r, typeColIndex) + ","), (int)typeColWidth);
            buf.append(cell);
            buf.append(" // ");
            cell = StringUtils.rightPad((String)structure.get(r, indxColIndex), (int)indxColWidth);
            buf.append(cell);
            buf.append(' ');
            cell = StringUtils.rightPad((String)structure.get(r, nameColIndex), (int)nameColWidth);
            buf.append(cell);
            buf.append(' ');
            buf.append('\n');
        }
        buf.append("}");
        buf.append('\n');
        return buf.toString();
    }

    private static String[] selectColumnNames(List<String> names, ColumnType[] types) {
        ArrayList<String> header = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == ColumnType.SKIP) continue;
            header.add(names.get(i).trim());
        }
        String[] result = new String[header.size()];
        return header.toArray(result);
    }

    private static String[] makeColumnNames(ColumnType[] types) {
        String[] header = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            header[i] = "C" + i;
        }
        return header;
    }

    protected static ColumnType[] detectColumnTypes(InputStream stream, boolean header, char delimiter, boolean skipSampling) throws IOException {
        int linesToSkip = header ? 1 : 0;
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        ArrayList columnData = new ArrayList();
        int rowCount = 0;
        UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(stream);
        ubis.skipBOM();
        CSVParser csvParser = new CSVParserBuilder().withSeparator(delimiter).build();
        Throwable throwable = null;
        try (CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(ubis)).withCSVParser((ICSVParser)csvParser).withSkipLines(linesToSkip).build();){
            String[] nextLine;
            int nextRow = 0;
            while ((nextLine = reader.readNext()) != null) {
                if (rowCount == 0) {
                    for (int j = 0; j < nextLine.length; ++j) {
                        columnData.add(new ArrayList());
                    }
                }
                int columnNumber = 0;
                if (rowCount == nextRow) {
                    for (String field : nextLine) {
                        ((List)columnData.get(columnNumber)).add(field);
                        ++columnNumber;
                    }
                }
                if (rowCount == nextRow) {
                    nextRow = skipSampling ? CsvReader.nextRowWithoutSampling(nextRow) : CsvReader.nextRow(nextRow);
                }
                ++rowCount;
            }
        }
        catch (Throwable nextLine) {
            Throwable throwable2 = nextLine;
            throw nextLine;
        }
        for (List list : columnData) {
            ColumnType detectedType = CsvReader.detectType(list);
            columnTypes.add(detectedType);
        }
        return columnTypes.toArray(new ColumnType[columnTypes.size()]);
    }

    private static int nextRowWithoutSampling(int nextRow) {
        return nextRow + 1;
    }

    private static int nextRow(int nextRow) {
        if (nextRow < 100) {
            return nextRow + 1;
        }
        if (nextRow < 1000) {
            return nextRow + 10;
        }
        if (nextRow < 10000) {
            return nextRow + 100;
        }
        if (nextRow < 100000) {
            return nextRow + 1000;
        }
        if (nextRow < 1000000) {
            return nextRow + 10000;
        }
        if (nextRow < 10000000) {
            return nextRow + 100000;
        }
        if (nextRow < 100000000) {
            return nextRow + 1000000;
        }
        return nextRow + 10000000;
    }

    private static ColumnType detectType(List<String> valuesList) {
        ColumnType[] typeArray = new ColumnType[]{ColumnType.LOCAL_DATE_TIME, ColumnType.LOCAL_TIME, ColumnType.LOCAL_DATE, ColumnType.BOOLEAN, ColumnType.SHORT_INT, ColumnType.INTEGER, ColumnType.LONG_INT, ColumnType.FLOAT, ColumnType.DOUBLE};
        CopyOnWriteArrayList<ColumnType> typeCandidates = new CopyOnWriteArrayList<ColumnType>(typeArray);
        for (String s : valuesList) {
            if (Strings.isNullOrEmpty((String)s) || TypeUtils.MISSING_INDICATORS.contains((Object)s)) continue;
            if (typeCandidates.contains((Object)ColumnType.LOCAL_DATE_TIME) && !isLocalDateTime.test(s)) {
                typeCandidates.remove((Object)ColumnType.LOCAL_DATE_TIME);
            }
            if (typeCandidates.contains((Object)ColumnType.LOCAL_TIME) && !isLocalTime.test(s)) {
                typeCandidates.remove((Object)ColumnType.LOCAL_TIME);
            }
            if (typeCandidates.contains((Object)ColumnType.LOCAL_DATE) && !isLocalDate.test(s)) {
                typeCandidates.remove((Object)ColumnType.LOCAL_DATE);
            }
            if (typeCandidates.contains((Object)ColumnType.BOOLEAN) && !isBoolean.test(s)) {
                typeCandidates.remove((Object)ColumnType.BOOLEAN);
            }
            if (typeCandidates.contains((Object)ColumnType.SHORT_INT) && !isShort.test(s)) {
                typeCandidates.remove((Object)ColumnType.SHORT_INT);
            }
            if (typeCandidates.contains((Object)ColumnType.INTEGER) && !isInteger.test(s)) {
                typeCandidates.remove((Object)ColumnType.INTEGER);
            }
            if (typeCandidates.contains((Object)ColumnType.LONG_INT) && !isLong.test(s)) {
                typeCandidates.remove((Object)ColumnType.LONG_INT);
            }
            if (typeCandidates.contains((Object)ColumnType.FLOAT) && !isFloat.test(s)) {
                typeCandidates.remove((Object)ColumnType.FLOAT);
            }
            if (!typeCandidates.contains((Object)ColumnType.DOUBLE) || isDouble.test(s)) continue;
            typeCandidates.remove((Object)ColumnType.DOUBLE);
        }
        return CsvReader.selectType(typeCandidates);
    }

    private static ColumnType selectType(List<ColumnType> typeCandidates) {
        if (typeCandidates.isEmpty()) {
            return ColumnType.CATEGORY;
        }
        return typeCandidates.get(0);
    }
}

