/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.util.Selection;

@Immutable
public class Rows {
    private Rows() {
    }

    public static void copyRowsToTable(IntArrayList rows, Table oldTable, Table newTable) {
        block12: for (int columnIndex = 0; columnIndex < oldTable.columnCount(); ++columnIndex) {
            ColumnType columnType = oldTable.column(columnIndex).type();
            switch (columnType) {
                case FLOAT: {
                    Rows.copy(rows, (FloatColumn)oldTable.column(columnIndex), (FloatColumn)newTable.column(columnIndex));
                    continue block12;
                }
                case INTEGER: {
                    Rows.copy(rows, (IntColumn)oldTable.column(columnIndex), (IntColumn)newTable.column(columnIndex));
                    continue block12;
                }
                case SHORT_INT: {
                    Rows.copy(rows, (ShortColumn)oldTable.column(columnIndex), (ShortColumn)newTable.column(columnIndex));
                    continue block12;
                }
                case LONG_INT: {
                    Rows.copy(rows, (LongColumn)oldTable.column(columnIndex), (LongColumn)newTable.column(columnIndex));
                    continue block12;
                }
                case CATEGORY: {
                    Rows.copy(rows, (CategoryColumn)oldTable.column(columnIndex), (CategoryColumn)newTable.column(columnIndex));
                    continue block12;
                }
                case BOOLEAN: {
                    Rows.copy(rows, (BooleanColumn)oldTable.column(columnIndex), (BooleanColumn)newTable.column(columnIndex));
                    continue block12;
                }
                case DOUBLE: {
                    Rows.copy(rows, (DoubleColumn)oldTable.column(columnIndex), (DoubleColumn)newTable.column(columnIndex));
                    continue block12;
                }
                case LOCAL_DATE: {
                    Rows.copy(rows, (DateColumn)oldTable.column(columnIndex), (DateColumn)newTable.column(columnIndex));
                    continue block12;
                }
                case LOCAL_DATE_TIME: {
                    Rows.copy(rows, (DateTimeColumn)oldTable.column(columnIndex), (DateTimeColumn)newTable.column(columnIndex));
                    continue block12;
                }
                case LOCAL_TIME: {
                    Rows.copy(rows, (TimeColumn)oldTable.column(columnIndex), (TimeColumn)newTable.column(columnIndex));
                    continue block12;
                }
                default: {
                    throw new RuntimeException("Unhandled column type in case statement");
                }
            }
        }
    }

    public static void appendRowToTable(int row, Table oldTable, Table newTable) {
        IntArrayList rows = new IntArrayList();
        rows.add(row);
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }

    public static boolean compareRows(int rowInOriginal, Table original, Table tempTable) {
        block12: for (int columnIndex = 0; columnIndex < original.columnCount(); ++columnIndex) {
            ColumnType columnType = original.column(columnIndex).type();
            switch (columnType) {
                case FLOAT: {
                    boolean result = Rows.compare(rowInOriginal, (FloatColumn)tempTable.column(columnIndex), (FloatColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                case DOUBLE: {
                    boolean result = Rows.compare(rowInOriginal, (DoubleColumn)tempTable.column(columnIndex), (DoubleColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                case INTEGER: {
                    boolean result = Rows.compare(rowInOriginal, (IntColumn)tempTable.column(columnIndex), (IntColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                case SHORT_INT: {
                    boolean result = Rows.compare(rowInOriginal, (ShortColumn)tempTable.column(columnIndex), (ShortColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                case LONG_INT: {
                    boolean result = Rows.compare(rowInOriginal, (LongColumn)tempTable.column(columnIndex), (LongColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                case CATEGORY: {
                    boolean result = Rows.compare(rowInOriginal, (CategoryColumn)tempTable.column(columnIndex), (CategoryColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                case BOOLEAN: {
                    boolean result = Rows.compare(rowInOriginal, (BooleanColumn)tempTable.column(columnIndex), (BooleanColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                case LOCAL_DATE: {
                    boolean result = Rows.compare(rowInOriginal, (DateColumn)tempTable.column(columnIndex), (DateColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                case LOCAL_DATE_TIME: {
                    boolean result = Rows.compare(rowInOriginal, (DateTimeColumn)tempTable.column(columnIndex), (DateTimeColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                case LOCAL_TIME: {
                    boolean result = Rows.compare(rowInOriginal, (TimeColumn)tempTable.column(columnIndex), (TimeColumn)original.column(columnIndex));
                    if (result) continue block12;
                    return false;
                }
                default: {
                    throw new RuntimeException("Unhandled column type in case statement");
                }
            }
        }
        return true;
    }

    public static void copyRowsToTable(Selection rows, Table oldTable, Table newTable) {
        int[] r = rows.toArray();
        IntArrayList rowArray = new IntArrayList(r);
        Rows.copyRowsToTable(rowArray, oldTable, newTable);
    }

    public static void head(int rowCount, Table oldTable, Table newTable) {
        IntArrayList rows = new IntArrayList(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            rows.add(i);
        }
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }

    public static void tail(int rowsToInclude, Table oldTable, Table newTable) {
        int oldTableSize = oldTable.rowCount();
        int start = oldTableSize - rowsToInclude;
        IntArrayList rows = new IntArrayList(rowsToInclude);
        for (int i = start; i < oldTableSize; ++i) {
            rows.add(i);
        }
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }

    private static void copy(IntArrayList rows, FloatColumn oldColumn, FloatColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static void copy(IntArrayList rows, DoubleColumn oldColumn, DoubleColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, FloatColumn tempTable, FloatColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static boolean compare(int row, DoubleColumn tempTable, DoubleColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, CategoryColumn oldColumn, CategoryColumn newColumn) {
        newColumn.initializeWith(oldColumn.getValues(rows), oldColumn.dictionaryMap());
    }

    private static boolean compare(int row, CategoryColumn tempTable, CategoryColumn original) {
        String t = tempTable.get(tempTable.size() - 1);
        String o = original.get(row);
        return o.equals(t);
    }

    private static void copy(IntArrayList rows, BooleanColumn oldColumn, BooleanColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, BooleanColumn tempTable, BooleanColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, IntColumn oldColumn, IntColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, IntColumn tempTable, IntColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, ShortColumn oldColumn, ShortColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, ShortColumn tempTable, ShortColumn original) {
        short t = tempTable.get(tempTable.size() - 1);
        short o = original.get(row);
        return o == t;
    }

    private static void copy(IntArrayList rows, LongColumn oldColumn, LongColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, LongColumn tempTable, LongColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, DateTimeColumn oldColumn, DateTimeColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.getLong(index));
        }
    }

    private static boolean compare(int row, DateTimeColumn tempTable, DateTimeColumn original) {
        return original.getLong(row) == tempTable.getLong(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, DateColumn oldColumn, DateColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.getInt(index));
        }
    }

    private static boolean compare(int row, DateColumn tempTable, DateColumn original) {
        return original.getInt(row) == tempTable.getInt(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, TimeColumn oldColumn, TimeColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.getInt(index));
        }
    }

    private static boolean compare(int row, TimeColumn tempTable, TimeColumn original) {
        return original.getInt(row) == tempTable.getInt(tempTable.size() - 1);
    }
}

