/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering;

import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.util.Selection;

public class IntNotEqualTo
extends ColumnFilter {
    private int value;

    public IntNotEqualTo(ColumnReference reference, int value) {
        super(reference);
        this.value = value;
    }

    @Override
    public Selection apply(Table table) {
        Column column = table.column(this.columnReference.getColumnName());
        ColumnType type = column.type();
        switch (type) {
            case INTEGER: {
                IntColumn intColumn = (IntColumn)column;
                return intColumn.isNotEqualTo(this.value);
            }
            case SHORT_INT: {
                ShortColumn shorts = (ShortColumn)column;
                return shorts.isNotEqualTo((short)this.value);
            }
            case LONG_INT: {
                LongColumn longs = (LongColumn)column;
                return longs.isNotEqualTo(this.value);
            }
            case FLOAT: {
                FloatColumn floats = (FloatColumn)column;
                return floats.isNotEqualTo(this.value);
            }
        }
        throw new UnsupportedOperationException("IsEqualTo(anInt) is not supported for column type " + (Object)((Object)type));
    }
}

