/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.LongColumnUtils;
import tech.tablesaw.columns.packeddata.PackedLocalDateTime;
import tech.tablesaw.filtering.LocalDateTimePredicate;
import tech.tablesaw.filtering.LongBiPredicate;
import tech.tablesaw.filtering.LongPredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.mapping.DateTimeMapUtils;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.ReverseLongComparator;
import tech.tablesaw.util.Selection;

public class DateTimeColumn
extends AbstractColumn
implements DateTimeMapUtils,
Iterable<LocalDateTime> {
    public static final long MISSING_VALUE = Long.MIN_VALUE;
    private static final int BYTE_SIZE = 8;
    private static int DEFAULT_ARRAY_SIZE = 128;
    private LongComparator reverseLongComparator = new LongComparator(){

        public int compare(Long o2, Long o1) {
            return o1 < o2 ? -1 : (o1.equals(o2) ? 0 : 1);
        }

        public int compare(long o2, long o1) {
            return o1 < o2 ? -1 : (o1 == o2 ? 0 : 1);
        }
    };
    private LongArrayList data;
    IntComparator comparator = new IntComparator(){

        public int compare(Integer r1, Integer r2) {
            return this.compare((int)r1, (int)r2);
        }

        public int compare(int r1, int r2) {
            long f1 = DateTimeColumn.this.getLong(r1);
            long f2 = DateTimeColumn.this.getLong(r2);
            return Long.compare(f1, f2);
        }
    };
    private TypeUtils.DateTimeConverter selectedFormatter;

    public DateTimeColumn(String name) {
        super(name);
        this.data = new LongArrayList(DEFAULT_ARRAY_SIZE);
    }

    public DateTimeColumn(ColumnMetadata metadata) {
        super(metadata);
        this.data = new LongArrayList(DEFAULT_ARRAY_SIZE);
    }

    public DateTimeColumn(String name, int initialSize) {
        super(name);
        this.data = new LongArrayList(initialSize);
    }

    public DateTimeColumn(String name, LongArrayList data) {
        super(name);
        this.data = data;
    }

    @Override
    public void appendCell(String stringValue) {
        if (stringValue == null) {
            this.append(Long.MIN_VALUE);
        } else {
            long dateTime = this.convert(stringValue);
            this.append(dateTime);
        }
    }

    public void add(LocalDateTime dateTime) {
        if (dateTime != null) {
            long dt = PackedLocalDateTime.pack(dateTime);
            this.append(dt);
        } else {
            this.append(Long.MIN_VALUE);
        }
    }

    public long convert(String value) {
        if (Strings.isNullOrEmpty((String)value) || TypeUtils.MISSING_INDICATORS.contains((Object)value) || value.equals("-1")) {
            return Long.MIN_VALUE;
        }
        value = Strings.padStart((String)value, (int)4, (char)'0');
        if (this.selectedFormatter == null) {
            this.selectedFormatter = TypeUtils.getDateTimeFormatter(value);
        }
        LocalDateTime datetime = this.selectedFormatter.convert(value);
        return PackedLocalDateTime.pack(datetime);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public LongArrayList data() {
        return this.data;
    }

    @Override
    public ColumnType type() {
        return ColumnType.LOCAL_DATE_TIME;
    }

    public void append(long dateTime) {
        this.data.add(dateTime);
    }

    public void append(LocalDateTime dateTime) {
        this.data.add(PackedLocalDateTime.pack(dateTime));
    }

    @Override
    public String getString(int row) {
        return PackedLocalDateTime.toString(this.getLong(row));
    }

    @Override
    public DateTimeColumn emptyCopy() {
        DateTimeColumn column = new DateTimeColumn(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public DateTimeColumn emptyCopy(int rowSize) {
        DateTimeColumn column = new DateTimeColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public DateTimeColumn copy() {
        DateTimeColumn column = new DateTimeColumn(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        LongArrays.parallelQuickSort((long[])this.data.elements(), (LongComparator)this.reverseLongComparator);
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        CategoryColumn measure = new CategoryColumn("Measure");
        CategoryColumn value = new CategoryColumn("Value");
        table.addColumn(measure);
        table.addColumn(value);
        measure.add("Count");
        value.add(String.valueOf(this.size()));
        measure.add("Missing");
        value.add(String.valueOf(this.countMissing()));
        measure.add("Earliest");
        value.add(String.valueOf(this.min()));
        measure.add("Latest");
        value.add(String.valueOf(this.max()));
        return table;
    }

    @Override
    public int countUnique() {
        LongOpenHashSet ints = new LongOpenHashSet(this.data.size());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            ints.add(i);
        }
        return ints.size();
    }

    @Override
    public DateTimeColumn unique() {
        LongOpenHashSet ints = new LongOpenHashSet(this.data.size());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            ints.add(i);
        }
        return new DateTimeColumn(this.name() + " Unique values", LongArrayList.wrap((long[])ints.toLongArray()));
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public long getLong(int index) {
        return this.data.getLong(index);
    }

    @Override
    public LocalDateTime get(int index) {
        return PackedLocalDateTime.asLocalDateTime(this.getLong(index));
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public CategoryColumn dayOfWeek() {
        CategoryColumn newColumn = new CategoryColumn(this.name() + " day of week", this.size());
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if (c1 == Long.MIN_VALUE) {
                newColumn.set(r, null);
                continue;
            }
            newColumn.add(PackedLocalDateTime.getDayOfWeek(c1).toString());
        }
        return newColumn;
    }

    public ShortColumn dayOfWeekValue() {
        ShortColumn newColumn = new ShortColumn(this.name() + " day of week", this.size());
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if (c1 == Long.MIN_VALUE) {
                newColumn.set(r, ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append((short)PackedLocalDateTime.getDayOfWeek(c1).getValue());
        }
        return newColumn;
    }

    public ShortColumn dayOfYear() {
        ShortColumn newColumn = new ShortColumn(this.name() + " day of year", this.size());
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if (c1 == Long.MIN_VALUE) {
                newColumn.append(ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append((short)PackedLocalDateTime.getDayOfYear(c1));
        }
        return newColumn;
    }

    public ShortColumn dayOfMonth() {
        ShortColumn newColumn = new ShortColumn(this.name() + " day of month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if ((float)c1 == FloatColumn.MISSING_VALUE) {
                newColumn.append(ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDateTime.getDayOfMonth(c1));
        }
        return newColumn;
    }

    public TimeColumn time() {
        TimeColumn newColumn = new TimeColumn(this.name() + " time");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if (c1 == Long.MIN_VALUE) {
                newColumn.append(TimeColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDateTime.time(c1));
        }
        return newColumn;
    }

    public DateColumn date() {
        DateColumn newColumn = new DateColumn(this.name() + " date");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if (c1 == Long.MIN_VALUE) {
                newColumn.append(DateColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDateTime.date(c1));
        }
        return newColumn;
    }

    public ShortColumn monthNumber() {
        ShortColumn newColumn = new ShortColumn(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if (c1 == Long.MIN_VALUE) {
                newColumn.append(ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDateTime.getMonthValue(c1));
        }
        return newColumn;
    }

    public CategoryColumn monthName() {
        CategoryColumn newColumn = new CategoryColumn(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if (c1 == Long.MIN_VALUE) {
                newColumn.add(CategoryColumn.MISSING_VALUE);
                continue;
            }
            newColumn.add(Month.of(PackedLocalDateTime.getMonthValue(c1)).name());
        }
        return newColumn;
    }

    public ShortColumn year() {
        ShortColumn newColumn = new ShortColumn(this.name() + " year");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if (c1 == Long.MIN_VALUE) {
                newColumn.append(ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(PackedLocalDateTime.getYear(PackedLocalDateTime.date(c1)));
        }
        return newColumn;
    }

    public Selection isEqualTo(LocalDateTime value) {
        long packed = PackedLocalDateTime.pack(value);
        return this.select(LongColumnUtils.isEqualTo, packed);
    }

    public Selection isEqualTo(DateTimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        LongIterator intIterator = column.longIterator();
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            if (next == intIterator.nextLong()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isAfter(LocalDateTime value) {
        return this.select(LongColumnUtils.isGreaterThan, PackedLocalDateTime.pack(value));
    }

    public Selection isAfter(Long packedDateTime) {
        return this.select(LongColumnUtils.isGreaterThan, packedDateTime);
    }

    public Selection isOnOrAfter(long value) {
        return this.select(LongColumnUtils.isGreaterThanOrEqualTo, value);
    }

    public Selection isOnOrAfter(LocalDateTime value) {
        return this.select(LongColumnUtils.isGreaterThanOrEqualTo, PackedLocalDateTime.pack(value));
    }

    public Selection isBefore(LocalDateTime value) {
        return this.select(LongColumnUtils.isLessThan, PackedLocalDateTime.pack(value));
    }

    public Selection isBefore(Long packedDateTime) {
        return this.select(LongColumnUtils.isLessThan, packedDateTime);
    }

    public Selection isOnOrBefore(long value) {
        return this.select(LongColumnUtils.isLessThanOrEqualTo, value);
    }

    public Selection isOnOrBefore(LocalDateTime value) {
        return this.select(LongColumnUtils.isLessThanOrEqualTo, PackedLocalDateTime.pack(value));
    }

    public Selection isAfter(DateTimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        LongIterator intIterator = column.longIterator();
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            if (next > intIterator.nextLong()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isBefore(DateTimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        LongIterator intIterator = column.longIterator();
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            if (next < intIterator.nextLong()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getLong(i) != Long.MIN_VALUE) continue;
            ++count;
        }
        return count;
    }

    public long[] toEpochSecondArray() {
        return this.toEpochSecondArray(ZoneOffset.UTC);
    }

    public long[] toEpochSecondArray(ZoneOffset offset) {
        long[] output = new long[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = PackedLocalDateTime.asLocalDateTime(this.data.getLong(i)).toEpochSecond(offset);
        }
        return output;
    }

    public long[] toEpochMillisArray() {
        return this.toEpochMillisArray(ZoneOffset.UTC);
    }

    public long[] toEpochMillisArray(ZoneOffset offset) {
        long[] output = new long[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = PackedLocalDateTime.asLocalDateTime(this.data.getLong(i)).toInstant(offset).toEpochMilli();
        }
        return output;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            builder.append(String.valueOf(PackedLocalDateTime.asLocalDateTime(next)));
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public Selection isMissing() {
        return this.select(isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(isNotMissing);
    }

    public String toString() {
        return "LocalDateTime column: " + this.name();
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DateTimeColumn intColumn = (DateTimeColumn)column;
        for (int i = 0; i < intColumn.size(); ++i) {
            this.add(intColumn.get(i));
        }
    }

    public LocalDateTime max() {
        if (this.isEmpty()) {
            return null;
        }
        long max = this.getLong(0);
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long aData = (Long)longListIterator.next();
            if (Long.MIN_VALUE == aData) continue;
            max = max > aData ? max : aData;
        }
        if (Long.MIN_VALUE == max) {
            return null;
        }
        return PackedLocalDateTime.asLocalDateTime(max);
    }

    public LocalDateTime min() {
        if (this.isEmpty()) {
            return null;
        }
        long min = this.getLong(0);
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long aData = (Long)longListIterator.next();
            if (Long.MIN_VALUE == aData) continue;
            min = min < aData ? min : aData;
        }
        if (Integer.MIN_VALUE == min) {
            return null;
        }
        return PackedLocalDateTime.asLocalDateTime(min);
    }

    @Override
    public ShortColumn minuteOfDay() {
        ShortColumn newColumn = new ShortColumn(this.name() + " minute of day");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLong(r);
            if (c1 == Long.MIN_VALUE) {
                newColumn.append(ShortColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append((short)PackedLocalDateTime.getMinuteOfDay(c1));
        }
        return newColumn;
    }

    public DateTimeColumn selectIf(LocalDateTimePredicate predicate) {
        DateTimeColumn column = this.emptyCopy();
        LongIterator iterator = this.longIterator();
        while (iterator.hasNext()) {
            long next = iterator.nextLong();
            if (!predicate.test(PackedLocalDateTime.asLocalDateTime(next))) continue;
            column.append(next);
        }
        return column;
    }

    public DateTimeColumn selectIf(LongPredicate predicate) {
        DateTimeColumn column = this.emptyCopy();
        LongIterator iterator = this.longIterator();
        while (iterator.hasNext()) {
            long next = iterator.nextLong();
            if (!predicate.test(next)) continue;
            column.append(next);
        }
        return column;
    }

    public Selection isMonday() {
        return this.select(PackedLocalDateTime::isMonday);
    }

    public Selection isTuesday() {
        return this.select(PackedLocalDateTime::isTuesday);
    }

    public Selection isWednesday() {
        return this.select(PackedLocalDateTime::isWednesday);
    }

    public Selection isThursday() {
        return this.select(PackedLocalDateTime::isThursday);
    }

    public Selection isFriday() {
        return this.select(PackedLocalDateTime::isFriday);
    }

    public Selection isSaturday() {
        return this.select(PackedLocalDateTime::isSaturday);
    }

    public Selection isSunday() {
        return this.select(PackedLocalDateTime::isSunday);
    }

    public Selection isInJanuary() {
        return this.select(PackedLocalDateTime::isInJanuary);
    }

    public Selection isInFebruary() {
        return this.select(PackedLocalDateTime::isInFebruary);
    }

    public Selection isInMarch() {
        return this.select(PackedLocalDateTime::isInMarch);
    }

    public Selection isInApril() {
        return this.select(PackedLocalDateTime::isInApril);
    }

    public Selection isInMay() {
        return this.select(PackedLocalDateTime::isInMay);
    }

    public Selection isInJune() {
        return this.select(PackedLocalDateTime::isInJune);
    }

    public Selection isInJuly() {
        return this.select(PackedLocalDateTime::isInJuly);
    }

    public Selection isInAugust() {
        return this.select(PackedLocalDateTime::isInAugust);
    }

    public Selection isInSeptember() {
        return this.select(PackedLocalDateTime::isInSeptember);
    }

    public Selection isInOctober() {
        return this.select(PackedLocalDateTime::isInOctober);
    }

    public Selection isInNovember() {
        return this.select(PackedLocalDateTime::isInNovember);
    }

    public Selection isInDecember() {
        return this.select(PackedLocalDateTime::isInDecember);
    }

    public Selection isFirstDayOfMonth() {
        return this.select(PackedLocalDateTime::isFirstDayOfMonth);
    }

    public Selection isLastDayOfMonth() {
        return this.select(PackedLocalDateTime::isLastDayOfMonth);
    }

    public Selection isInQ1() {
        return this.select(PackedLocalDateTime::isInQ1);
    }

    public Selection isInQ2() {
        return this.select(PackedLocalDateTime::isInQ2);
    }

    public Selection isInQ3() {
        return this.select(PackedLocalDateTime::isInQ3);
    }

    public Selection isInQ4() {
        return this.select(PackedLocalDateTime::isInQ4);
    }

    public Selection isNoon() {
        return this.select(PackedLocalDateTime::isNoon);
    }

    public Selection isMidnight() {
        return this.select(PackedLocalDateTime::isMidnight);
    }

    public Selection isBeforeNoon() {
        return this.select(PackedLocalDateTime::AM);
    }

    public Selection isAfterNoon() {
        return this.select(PackedLocalDateTime::PM);
    }

    public Selection select(LongPredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            long next = this.data.getLong(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public Selection select(LongBiPredicate predicate, long value) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            long next = this.data.getLong(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public List<LocalDateTime> top(int n) {
        ArrayList<LocalDateTime> top = new ArrayList<LocalDateTime>();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values, (LongComparator)ReverseLongComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(PackedLocalDateTime.asLocalDateTime(values[i]));
        }
        return top;
    }

    public List<LocalDateTime> bottom(int n) {
        ArrayList<LocalDateTime> bottom = new ArrayList<LocalDateTime>();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(PackedLocalDateTime.asLocalDateTime(values[i]));
        }
        return bottom;
    }

    public LongIterator longIterator() {
        return this.data.iterator();
    }

    public Set<LocalDateTime> asSet() {
        HashSet<LocalDateTime> times = new HashSet<LocalDateTime>();
        DateTimeColumn unique = this.unique();
        for (LocalDateTime localDateTime : unique) {
            times.add(localDateTime);
        }
        return times;
    }

    public Selection isInYear(int year) {
        return this.select(i -> PackedLocalDateTime.isInYear(i, year));
    }

    public boolean contains(LocalDateTime dateTime) {
        long dt = PackedLocalDateTime.pack(dateTime);
        return this.data().contains(dt);
    }

    @Override
    public int byteSize() {
        return 8;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(8).putLong(this.getLong(rowNumber)).array();
    }

    @Override
    public Iterator<LocalDateTime> iterator() {
        return new Iterator<LocalDateTime>(){
            LongIterator longIterator;
            {
                this.longIterator = DateTimeColumn.this.longIterator();
            }

            @Override
            public boolean hasNext() {
                return this.longIterator.hasNext();
            }

            @Override
            public LocalDateTime next() {
                return PackedLocalDateTime.asLocalDateTime(this.longIterator.nextLong());
            }
        };
    }

    @Override
    public DateTimeColumn difference() {
        throw new UnsupportedOperationException("DateTimeColumn.difference() currently not supported");
    }
}

