/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

@Immutable
public final class CsvWriter {
    private CsvWriter() {
    }

    public static void write(Table table, File file) throws IOException {
        try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(file));){
            String[] header = new String[table.columnCount()];
            for (int c = 0; c < table.columnCount(); ++c) {
                header[c] = table.column(c).name();
            }
            writer.writeNext(header, false);
            for (int r = 0; r < table.rowCount(); ++r) {
                String[] entries = new String[table.columnCount()];
                for (int c = 0; c < table.columnCount(); ++c) {
                    table.get(r, c);
                    entries[c] = table.get(r, c);
                }
                writer.writeNext(entries, false);
            }
        }
    }

    public static void write(Table table, String fileName) throws IOException {
        CsvWriter.write(table, new File(fileName));
    }

    public static void write(String fileName, Column column) throws IOException {
        try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(fileName));){
            String[] header = new String[]{column.name()};
            writer.writeNext(header, false);
            for (int r = 0; r < column.size(); ++r) {
                String[] entries = new String[]{column.getString(r)};
                writer.writeNext(entries, false);
            }
        }
    }
}

