/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.joining;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Row;
import tech.tablesaw.joining.ColumnIndexPair;
import tech.tablesaw.joining.RowComparatorChain;

class SortKey
implements Iterable<ColumnIndexPair> {
    private final ArrayList<ColumnIndexPair> sortOrder = new ArrayList();

    private SortKey(ColumnIndexPair pair) {
        this.next(pair);
    }

    public static SortKey on(ColumnIndexPair pair) {
        return new SortKey(pair);
    }

    public SortKey next(ColumnIndexPair pair) {
        this.sortOrder.add(pair);
        return this;
    }

    public boolean isEmpty() {
        return this.sortOrder.isEmpty();
    }

    public int size() {
        return this.sortOrder.size();
    }

    public static SortKey create(List<ColumnIndexPair> pairs) {
        SortKey key = null;
        for (ColumnIndexPair pair : pairs) {
            if (key == null) {
                key = new SortKey(pair);
                continue;
            }
            key.next(pair);
        }
        return key;
    }

    static RowComparatorChain getChain(SortKey key) {
        Iterator<ColumnIndexPair> entries = key.iterator();
        ColumnIndexPair sort = entries.next();
        Comparator<Row> comparator = SortKey.comparator(sort);
        RowComparatorChain chain = new RowComparatorChain(comparator);
        while (entries.hasNext()) {
            sort = entries.next();
            chain.addComparator(SortKey.comparator(sort));
        }
        return chain;
    }

    private static Comparator<Row> comparator(ColumnIndexPair pair) {
        if (pair.type.equals(ColumnType.INTEGER)) {
            return (r11, r21) -> {
                int b1 = r11.getInt(pair.left);
                int b2 = r21.getInt(pair.right);
                return Integer.compare(b1, b2);
            };
        }
        if (pair.type.equals(ColumnType.LOCAL_DATE)) {
            return (r11, r21) -> {
                int b1 = r11.getPackedDate(pair.left);
                int b2 = r21.getPackedDate(pair.right);
                return Integer.compare(b1, b2);
            };
        }
        if (pair.type.equals(ColumnType.LOCAL_TIME)) {
            return (r11, r21) -> {
                int b1 = r11.getPackedTime(pair.left);
                int b2 = r21.getPackedTime(pair.right);
                return Integer.compare(b1, b2);
            };
        }
        if (pair.type.equals(ColumnType.LONG)) {
            return (r11, r21) -> {
                long b1 = r11.getLong(pair.left);
                long b2 = r21.getLong(pair.right);
                return Long.compare(b1, b2);
            };
        }
        if (pair.type.equals(ColumnType.LOCAL_DATE_TIME)) {
            return (r11, r21) -> {
                long b1 = r11.getPackedDateTime(pair.left);
                long b2 = r21.getPackedDateTime(pair.right);
                return Long.compare(b1, b2);
            };
        }
        if (pair.type.equals(ColumnType.INSTANT)) {
            return (r11, r21) -> {
                long b1 = r11.getPackedInstant(pair.left);
                long b2 = r21.getPackedInstant(pair.right);
                return Long.compare(b1, b2);
            };
        }
        if (pair.type.equals(ColumnType.DOUBLE)) {
            return (r11, r21) -> {
                double b1 = r11.getDouble(pair.left);
                double b2 = r21.getDouble(pair.right);
                return Double.compare(b1, b2);
            };
        }
        if (pair.type.equals(ColumnType.FLOAT)) {
            return (r11, r21) -> {
                float b1 = r11.getFloat(pair.left);
                float b2 = r21.getFloat(pair.right);
                return Float.compare(b1, b2);
            };
        }
        if (pair.type.equals(ColumnType.BOOLEAN)) {
            return (r11, r21) -> {
                byte b1 = r11.getBooleanAsByte(pair.left);
                byte b2 = r21.getBooleanAsByte(pair.right);
                return Byte.compare(b1, b2);
            };
        }
        if (pair.type.equals(ColumnType.STRING)) {
            return (r11, r21) -> {
                String b1 = r11.getString(pair.left);
                String b2 = r21.getString(pair.right);
                return b1.compareTo(b2);
            };
        }
        throw new RuntimeException("Unhandled ColumnType in SortKey.");
    }

    @Override
    public Iterator<ColumnIndexPair> iterator() {
        return this.sortOrder.iterator();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("order", this.sortOrder).toString();
    }
}

